<?php 
 $GLOBALS["dictionary"]["RMA19_RMA"]=array (
  'table' => 'rma19_rma',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_SUBJECT',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'The short description of the bug',
      'merge_filter' => 'selected',
      'required' => true,
      'importable' => 'required',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'rma19_rma_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'rma19_rma_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'rma19_rma_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_rma19_rma',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'rma19_rma_number' => 
    array (
      'name' => 'rma19_rma_number',
      'vname' => 'LBL_NUMBER',
      'type' => 'int',
      'readonly' => true,
      'len' => 11,
      'required' => true,
      'auto_increment' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Visual unique identifier',
      'duplicate_merge' => 'disabled',
      'disable_num_format' => true,
      'studio' => 
      array (
        'quickcreate' => false,
      ),
      'inline_edit' => false,
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'rma19_rma_type_dom',
      'len' => 100,
      'comment' => 'The type of issue (ex: issue, feature)',
      'merge_filter' => 'disabled',
      'default' => 'Administration',
      'required' => true,
      'inline_edit' => true,
      'comments' => 'The type of issue (ex: issue, feature)',
    ),
    'status' => 
    array (
      'name' => 'status',
      'vname' => 'LBL_STATUS',
      'type' => 'enum',
      'options' => 'rma19_rma_status_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'The status of the issue',
      'merge_filter' => 'enabled',
    ),
    'priority' => 
    array (
      'name' => 'priority',
      'vname' => 'LBL_PRIORITY',
      'type' => 'enum',
      'options' => 'rma19_rma_priority_dom',
      'len' => 100,
      'audited' => true,
      'comment' => 'An indication of the priorty of the issue',
      'merge_filter' => 'enabled',
    ),
    'resolution' => 
    array (
      'name' => 'resolution',
      'vname' => 'LBL_RESOLUTION',
      'type' => 'enum',
      'options' => 'rma19_rma_resolution_dom',
      'len' => 255,
      'audited' => true,
      'comment' => 'An indication of how the issue was resolved',
      'merge_filter' => 'enabled',
    ),
    'work_log' => 
    array (
      'name' => 'work_log',
      'vname' => 'LBL_WORK_LOG',
      'type' => 'text',
      'comment' => 'Free-form text used to denote activities of interest',
    ),
    'rma19_rma_aos_invoices' => 
    array (
      'name' => 'rma19_rma_aos_invoices',
      'type' => 'link',
      'relationship' => 'rma19_rma_aos_invoices',
      'source' => 'non-db',
      'module' => 'AOS_Invoices',
      'bean_name' => 'AOS_Invoices',
      'vname' => 'LBL_RMA19_RMA_AOS_INVOICES_FROM_AOS_INVOICES_TITLE',
    ),
    'rma19_rma_am_projecttemplates' => 
    array (
      'name' => 'rma19_rma_am_projecttemplates',
      'type' => 'link',
      'relationship' => 'rma19_rma_am_projecttemplates',
      'source' => 'non-db',
      'module' => 'AM_ProjectTemplates',
      'bean_name' => 'AM_ProjectTemplates',
      'side' => 'right',
      'vname' => 'LBL_RMA19_RMA_AM_PROJECTTEMPLATES_FROM_AM_PROJECTTEMPLATES_TITLE',
    ),
    'servicesheet_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Service sheet nb',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'servicesheet_c',
      'vname' => 'LBL_SERVICESHEET',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => 'Please enter the service sheet number, contact Sabrina and Janelle',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAservicesheet_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'createdby_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Created by',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'createdby_c',
      'vname' => 'LBL_CREATEDBY',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'employees_list_tech',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => '',
      'id' => 'RMA19_RMAcreatedby_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'repairedby_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Repaired by',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'repairedby_c',
      'vname' => 'LBL_REPAIREDBY',
      'type' => 'dynamicenum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'repairedby_list',
      'studio' => 'visible',
      'dbType' => 'enum',
      'parentenum' => '',
      'id' => 'RMA19_RMArepairedby_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'poreceived_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'PO number',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'poreceived_c',
      'vname' => 'LBL_PORECEIVED',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAporeceived_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'serialnumbers_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Serial numbers',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'serialnumbers_c',
      'vname' => 'LBL_SERIALNUMBERS',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'RMA19_RMAserialnumbers_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'senttoci_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Sent to CI',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'senttoci_c',
      'vname' => 'LBL_SENTTOCI',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'RMA19_RMAsenttoci_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'receivedbackon_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Received back from CI',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'receivedbackon_c',
      'vname' => 'LBL_RECEIVEDBACKON',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'RMA19_RMAreceivedbackon_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'invoicedate_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Invoice date',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'invoicedate_c',
      'vname' => 'LBL_INVOICEDATE',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'dbType' => 'datetime',
      'id' => 'RMA19_RMAinvoicedate_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'invoicenb_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Invoice number',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'invoicenb_c',
      'vname' => 'LBL_INVOICENB',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAinvoicenb_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'notes_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Notes',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'notes_c',
      'vname' => 'LBL_NOTES',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'RMA19_RMAnotes_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'rmanumber_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'RMA Number',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'rmanumber_c',
      'vname' => 'LBL_RMANUMBER',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMArmanumber_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'chargeable_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Chargeable',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'chargeable_c',
      'vname' => 'LBL_CHARGEABLE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'account_stage_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'RMA19_RMAchargeable_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'address_city_c' => 
    array (
      'inline_edit' => 1,
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'address_city_c',
      'vname' => 'LBL_ADDRESS_CITY',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'RMA19_RMAaddress_city_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'address_state_c' => 
    array (
      'inline_edit' => 1,
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'address_state_c',
      'vname' => 'LBL_ADDRESS_STATE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'RMA19_RMAaddress_state_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'address_postalcode_c' => 
    array (
      'inline_edit' => 1,
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'address_postalcode_c',
      'vname' => 'LBL_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '20',
      'size' => '20',
      'id' => 'RMA19_RMAaddress_postalcode_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'address_country_c' => 
    array (
      'inline_edit' => 1,
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'address_country_c',
      'vname' => 'LBL_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '100',
      'size' => '20',
      'id' => 'RMA19_RMAaddress_country_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'address_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Address',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'address_c',
      'vname' => 'LBL_ADDRESS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAaddress_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'contactperson_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Contact name',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contactperson_c',
      'vname' => 'LBL_CONTACTPERSON',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAcontactperson_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'phone_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Phone Number',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'phone_c',
      'vname' => 'LBL_PHONE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAphone_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'email_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'email_c',
      'vname' => 'LBL_EMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAemail_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'company_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Company Name',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'company_c',
      'vname' => 'LBL_COMPANY',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'RMA19_RMAcompany_c',
      'custom_module' => 'RMA19_RMA',
    ),
    'rma19_rma_aos_quotes_1' => 
    array (
      'name' => 'rma19_rma_aos_quotes_1',
      'type' => 'link',
      'relationship' => 'rma19_rma_aos_quotes_1',
      'source' => 'non-db',
      'module' => 'AOS_Quotes',
      'bean_name' => 'AOS_Quotes',
      'vname' => 'LBL_RMA19_RMA_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
      'id_name' => 'rma19_rma_aos_quotes_1aos_quotes_idb',
    ),
    'rma19_rma_aos_quotes_1_name' => 
    array (
      'name' => 'rma19_rma_aos_quotes_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_RMA19_RMA_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
      'save' => true,
      'id_name' => 'rma19_rma_aos_quotes_1aos_quotes_idb',
      'link' => 'rma19_rma_aos_quotes_1',
      'table' => 'aos_quotes',
      'module' => 'AOS_Quotes',
      'rname' => 'name',
    ),
    'rma19_rma_aos_quotes_1aos_quotes_idb' => 
    array (
      'name' => 'rma19_rma_aos_quotes_1aos_quotes_idb',
      'type' => 'link',
      'relationship' => 'rma19_rma_aos_quotes_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_RMA19_RMA_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
    ),
    'rma19_rma_aos_invoices_1' => 
    array (
      'name' => 'rma19_rma_aos_invoices_1',
      'type' => 'link',
      'relationship' => 'rma19_rma_aos_invoices_1',
      'source' => 'non-db',
      'module' => 'AOS_Invoices',
      'bean_name' => 'AOS_Invoices',
      'vname' => 'LBL_RMA19_RMA_AOS_INVOICES_1_FROM_AOS_INVOICES_TITLE',
      'id_name' => 'rma19_rma_aos_invoices_1aos_invoices_idb',
    ),
    'rma19_rma_aos_invoices_1_name' => 
    array (
      'name' => 'rma19_rma_aos_invoices_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_RMA19_RMA_AOS_INVOICES_1_FROM_AOS_INVOICES_TITLE',
      'save' => true,
      'id_name' => 'rma19_rma_aos_invoices_1aos_invoices_idb',
      'link' => 'rma19_rma_aos_invoices_1',
      'table' => 'aos_invoices',
      'module' => 'AOS_Invoices',
      'rname' => 'name',
    ),
    'rma19_rma_aos_invoices_1aos_invoices_idb' => 
    array (
      'name' => 'rma19_rma_aos_invoices_1aos_invoices_idb',
      'type' => 'link',
      'relationship' => 'rma19_rma_aos_invoices_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_RMA19_RMA_AOS_INVOICES_1_FROM_AOS_INVOICES_TITLE',
    ),
    'rma19_rma_accounts_1' => 
    array (
      'name' => 'rma19_rma_accounts_1',
      'type' => 'link',
      'relationship' => 'rma19_rma_accounts_1',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_RMA19_RMA_ACCOUNTS_1_FROM_ACCOUNTS_TITLE',
      'id_name' => 'rma19_rma_accounts_1accounts_idb',
    ),
    'rma19_rma_accounts_1_name' => 
    array (
      'name' => 'rma19_rma_accounts_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_RMA19_RMA_ACCOUNTS_1_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'rma19_rma_accounts_1accounts_idb',
      'link' => 'rma19_rma_accounts_1',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'rma19_rma_accounts_1accounts_idb' => 
    array (
      'name' => 'rma19_rma_accounts_1accounts_idb',
      'type' => 'link',
      'relationship' => 'rma19_rma_accounts_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_RMA19_RMA_ACCOUNTS_1_FROM_ACCOUNTS_TITLE',
    ),
    'srs03_servicerecordsheet_rma19_rma_1' => 
    array (
      'name' => 'srs03_servicerecordsheet_rma19_rma_1',
      'type' => 'link',
      'relationship' => 'srs03_servicerecordsheet_rma19_rma_1',
      'source' => 'non-db',
      'module' => 'srs03_Servicerecordsheet',
      'bean_name' => 'srs03_Servicerecordsheet',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_RMA19_RMA_1_FROM_SRS03_SERVICERECORDSHEET_TITLE',
      'id_name' => 'srs03_servicerecordsheet_rma19_rma_1srs03_servicerecordsheet_ida',
    ),
    'srs03_servicerecordsheet_rma19_rma_1_name' => 
    array (
      'name' => 'srs03_servicerecordsheet_rma19_rma_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_RMA19_RMA_1_FROM_SRS03_SERVICERECORDSHEET_TITLE',
      'save' => true,
      'id_name' => 'srs03_servicerecordsheet_rma19_rma_1srs03_servicerecordsheet_ida',
      'link' => 'srs03_servicerecordsheet_rma19_rma_1',
      'table' => 'srs03_servicerecordsheet',
      'module' => 'srs03_Servicerecordsheet',
      'rname' => 'name',
    ),
    'srs03_servicerecordsheet_rma19_rma_1srs03_servicerecordsheet_ida' => 
    array (
      'name' => 'srs03_servicerecordsheet_rma19_rma_1srs03_servicerecordsheet_ida',
      'type' => 'link',
      'relationship' => 'srs03_servicerecordsheet_rma19_rma_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_RMA19_RMA_1_FROM_SRS03_SERVICERECORDSHEET_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'rma19_rma_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'RMA19_RMA',
      'rhs_table' => 'rma19_rma',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'rma19_rma_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'RMA19_RMA',
      'rhs_table' => 'rma19_rma',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'rma19_rma_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'RMA19_RMA',
      'rhs_table' => 'rma19_rma',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_rma19_rma' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'RMA19_RMA',
      'rhs_table' => 'rma19_rma',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'RMA19_RMA',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'rma19_rmapk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    'number' => 
    array (
      'name' => 'rma19_rmanumk',
      'type' => 'unique',
      'fields' => 
      array (
        0 => 'rma19_rma_number',
      ),
    ),
  ),
  'templates' => 
  array (
    'issue' => 'issue',
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);