<?php 
 $GLOBALS["dictionary"]["HLI29_HighLevelIntegration"]=array (
  'table' => 'hli29_highlevelintegration',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'disabled',
      'merge_filter' => 'disabled',
      'inline_edit' => true,
      'duplicate_merge_dom_value' => '0',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'hli29_highlevelintegration_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'hli29_highlevelintegration_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'hli29_highlevelintegration_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_hli29_highlevelintegration',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'hli29_highlevelintegration_documents_1' => 
    array (
      'name' => 'hli29_highlevelintegration_documents_1',
      'type' => 'link',
      'relationship' => 'hli29_highlevelintegration_documents_1',
      'source' => 'non-db',
      'module' => 'Documents',
      'bean_name' => 'Document',
      'side' => 'right',
      'vname' => 'LBL_HLI29_HIGHLEVELINTEGRATION_DOCUMENTS_1_FROM_DOCUMENTS_TITLE',
    ),
    'interfacetype_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Interface Type',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'interfacetype_c',
      'vname' => 'LBL_INTERFACETYPE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'interfacetype_0',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'HLI29_HighLevelIntegrationinterfacetype_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'companyname_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'COMPANY NAME',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'companyname_c',
      'vname' => 'LBL_COMPANYNAME',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationcompanyname_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'sip_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'SIP',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'sip_c',
      'vname' => 'LBL_SIP',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationsip_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'contactname_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Contact Name',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contactname_c',
      'vname' => 'LBL_CONTACTNAME',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationcontactname_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'contactphone_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Phone',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contactphone_c',
      'vname' => 'LBL_CONTACTPHONE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationcontactphone_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'contactemail_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Email',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'contactemail_c',
      'vname' => 'LBL_CONTACTEMAIL',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationcontactemail_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'version_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'version',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'version_c',
      'vname' => 'LBL_VERSION',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationversion_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'productname_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Partner Product Name',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'productname_c',
      'vname' => 'LBL_PRODUCTNAME',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationproductname_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'direction_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Direction',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'direction_c',
      'vname' => 'LBL_DIRECTION',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'direction_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'HLI29_HighLevelIntegrationdirection_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'commendproduct_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Commend Product',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'commendproduct_c',
      'vname' => 'LBL_COMMENDPRODUCT',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'commendproduct_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'HLI29_HighLevelIntegrationcommendproduct_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'requirements_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Requirements',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'requirements_c',
      'vname' => 'LBL_REQUIREMENTS',
      'type' => 'text',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'studio' => 'visible',
      'rows' => '4',
      'cols' => '20',
      'id' => 'HLI29_HighLevelIntegrationrequirements_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
    'source_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Source',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'source_c',
      'vname' => 'LBL_SOURCE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => 'Gathered information source',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'HLI29_HighLevelIntegrationsource_c',
      'custom_module' => 'HLI29_HighLevelIntegration',
    ),
  ),
  'relationships' => 
  array (
    'hli29_highlevelintegration_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'HLI29_HighLevelIntegration',
      'rhs_table' => 'hli29_highlevelintegration',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'hli29_highlevelintegration_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'HLI29_HighLevelIntegration',
      'rhs_table' => 'hli29_highlevelintegration',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'hli29_highlevelintegration_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'HLI29_HighLevelIntegration',
      'rhs_table' => 'hli29_highlevelintegration',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_hli29_highlevelintegration' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'HLI29_HighLevelIntegration',
      'rhs_table' => 'hli29_highlevelintegration',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'HLI29_HighLevelIntegration',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'hli29_highlevelintegrationpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);