<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

/**
 * LICENSE: The contents of this file are subject to the license agreement ("License") which is included
 * in the installation package (LICENSE.txt). By installing or using this file, you have unconditionally
 * agreed to the terms and conditions of the License, and you may not use this file except in compliance
 * with the License.
 *
 * @author     Original Author ALS - Simbanic
 */

require_once 'modules/AOS_PDF_Templates/PDF_Lib/mpdf.php';

require_once 'custom/modules/AOS_PDF_Templates/simbaTemplateParser.php';

require_once 'modules/AOS_PDF_Templates/AOS_PDF_Templates.php';

global $sugar_config, $beanList;

if(isset($_REQUEST['module']) && !empty($_REQUEST['module']))
{
    $module_type = $_REQUEST['module'];
}
else
{
    $GLOBALS['log']->fatal(' SimbaEnhancePDF :: module params not exist '. print_r('simbaPrintPDF', true) . __FILE__ . __LINE__);
    exit();
}

$module_type_create = $beanList[$module_type];
$module_type_low = strtolower($module_type);
$module = new $module_type_create();
$variableName = strtolower($module_type);

$recordIds = array();

if (isset($_REQUEST['current_post']) && !empty($_REQUEST['current_post'])) {

    $order_by = '';

    require_once 'include/MassUpdate.php';

    $mass = new MassUpdate();
    $mass->generateSearchWhere($_REQUEST['module'], $_REQUEST['current_post']);
    $ret_array = create_export_query_relate_link_patch($_REQUEST['module'], $mass->searchFields, $mass->where_clauses);
    $query = $module->create_export_query($order_by, $ret_array['where'], $ret_array['join']);
    $result = $GLOBALS['db']->query($query, true);

    $uids = array();

    while ($val = $GLOBALS['db']->fetchByAssoc($result, false)) {
        array_push($recordIds, $val['id']);
    }
} else {
    $recordIds = explode(',', $_REQUEST['uid']);
}

$template = new AOS_PDF_Templates();

if(isset($_REQUEST['templateID']) && !empty($_REQUEST['templateID']))
{
    $template->retrieve($_REQUEST['templateID']);    
}
else
{
    $GLOBALS['log']->fatal(' simbaEnhancePDF :: templateID not exist'. print_r($_REQUEST, true) . __FILE__ . __LINE__);
}

$orientation = '';

$format = 'A4';

if ($template->landscap_c == '1' || $template->landscap_c == 'on') {
    $orientation = 'L';
    $format = 'A4-L';
}

$pdf = new mPDF('en', $format, '', 'DejaVuSansCondensed', $template->margin_left, $template->margin_right, $template->margin_top, $template->margin_bottom, $template->margin_header, $template->margin_footer, $orientation);

foreach ($recordIds as $recordId) {

    $module->retrieve($recordId);

    $lineItemsGroups = array();
	$lineItems = array();

	$sql = "SELECT pg.id, pg.product_id, pg.group_id FROM aos_products_quotes pg LEFT JOIN aos_line_item_groups lig ON pg.group_id = lig.id WHERE pg.parent_type = '" . $module->object_name . "' AND pg.parent_id = '" . $module->id . "' AND pg.deleted = 0 ORDER BY lig.number ASC, pg.number ASC";
	$res = $module->db->query($sql);

	while ($row = $module->db->fetchByAssoc($res))
	{
	    $lineItemsGroups[$row['group_id']][$row['id']] = $row['product_id'];
	    $lineItems[$row['id']] = $row['product_id'];
	}

    $pdf_history = new mPDF('en', $format, '', 'DejaVuSansCondensed', $template->margin_left, $template->margin_right, $template->margin_top, $template->margin_bottom, $template->margin_header, $template->margin_footer, $orientation);

    $object_arr = array();
    $object_arr[$module_type] = $module->id;

    if ($module_type === 'Contacts') {
        $object_arr['Accounts'] = $module->account_id;
    }

    $search = array(
        '@<script[^>]*?>.*?</script>@si', /* Strip out javascript */
        '@<[\/\!]*?[^<>]*?>@si', /* Strip out HTML tags */
        '@([\r\n])[\s]+@', /* Strip out white space */
        '@&(quot|#34);@i', /* Replace HTML entities */
        '@&(amp|#38);@i',
        '@&(lt|#60);@i',
        '@&(gt|#62);@i',
        '@&(nbsp|#160);@i',
        '@&(iexcl|#161);@i',
        '@<address[^>]*?>@si',

    );

    $replace = array(
        '',
        '',
        '\1',
        '"',
        '&',
        '<',
        '>',
        ' ',
        chr(161),
        '<br>',
    );

    $text = preg_replace($search, $replace, $template->description);
    $text = preg_replace_callback('/\{DATE\s+(.*?)\}/', function ($matches) {
        return date($matches[1]);
    }, $text);

    $text = str_replace("\$aos_quotes", "\$" . $variableName, $text);
	$text = str_replace("\$aos_invoices", "\$" . $variableName, $text);
	$text = str_replace("\$total_amt", "\$" . $variableName . "_total_amt", $text);
	$text = str_replace("\$discount_amount", "\$" . $variableName . "_discount_amount", $text);
	$text = str_replace("\$subtotal_amount", "\$" . $variableName . "_subtotal_amount", $text);
	$text = str_replace("\$tax_amount", "\$" . $variableName . "_tax_amount", $text);
	$text = str_replace("\$shipping_amount", "\$" . $variableName . "_shipping_amount", $text);
	$text = str_replace("\$total_amount", "\$" . $variableName . "_total_amount", $text);

	$text = populate_group_lines($text, $lineItemsGroups, $lineItems);

    $text = print_relationship_records($text, $module);

    $header = preg_replace($search, $replace, $template->pdfheader);
    $footer = preg_replace($search, $replace, $template->pdffooter);
    $converted = simbaTemplateParser::parse_template($text, $object_arr);
    
    $header = simbaTemplateParser::parse_template($header, $object_arr);
    $footer = simbaTemplateParser::parse_template($footer, $object_arr);
    $printable = str_replace("\n", "<br />", $converted);
    $file_name = str_replace(" ", "_", $template->name) . ".pdf";

    ob_clean();

    try {

        $note = new Note();

        $note->modified_user_id = $current_user->id;
        $note->created_by = $current_user->id;
        $note->name = $file_name;
        $note->parent_type = $module_type;
        $note->parent_id = $module->id;
        $note->file_mime_type = 'application/pdf';
        $note->filename = $file_name;

        if ($module_type == 'Contacts') {
            $note->contact_id = $module->id;
            $note->parent_type = 'Accounts';
            $note->parent_id = $module->account_id;
        }

        $note->save();

        $fp = fopen($sugar_config['upload_dir'] . 'nfile.pdf', 'wb');
        fclose($fp);

        $pdf_history->setAutoFont();
        $pdf_history->SetHTMLHeader($header);
        $pdf_history->SetHTMLFooter($footer);
        $pdf_history->writeHTML($printable);
        $pdf_history->Output($sugar_config['upload_dir'] . 'nfile.pdf', 'F');
        $pdf->AddPage();
        $pdf->setAutoFont();
        $pdf->SetHTMLHeader($header);
        $pdf->SetHTMLFooter($footer);
        $pdf->writeHTML($printable);

        rename($sugar_config['upload_dir'] . 'nfile.pdf', $sugar_config['upload_dir'] . $note->id);

    } catch (mPDF_exception $e) {
        $GLOBALS['log']->fatal(' :: '. print_r($e->getMessage(), true) . __FILE__ . __LINE__);
    }

}

$pdf->Output($file_name, "D");

function print_relationship_records($string, $focus)
{
    /* Get Relationships of modules. */

    $linked_fields = $focus->get_linked_fields();
    foreach ($linked_fields as $linked_field_defs) {

        if (isset($linked_field_defs['relationship'])) {
            $relationship_name = $linked_field_defs['relationship'];
            $relationship_bean_name = $linked_field_defs['bean_name'];
            $relationship_field_name = $linked_field_defs['name'];

        } else {
            continue;
        }

        $related_beans = $focus->get_linked_beans($relationship_field_name, $relationship_bean_name);

        unset($bean->$relationship_name);

        if (empty($related_beans) && !empty($relationship_bean_name)) {
            $related_beans[0] = new $relationship_bean_name();
        }

        $parts = get_line_for_relate_bean($string, $related_beans[0], $relationship_name);
        if ($parts === false) {
            continue;
        }

        $linePart = $parts['line_part'];
        $string = $parts['parts']['0'];

        foreach ($related_beans as $bean) {
            $string .= simbaTemplateParser::parse_template_bean($linePart, $relationship_name, $bean);
        }
        $string .= $parts['parts']['1'];
    }
    return $string;
}

function get_line_for_relate_bean($text, $bean, $relationship_name, $element = 'tr')
{
    $firstValue = '';
    $firstNum = 0;
    $lastValue = '';
    $lastNum = 0;
    $startElement = '<' . $element;
    $endElement = '</' . $element . '>';

    /* Find first and last valid line values */
    foreach ($bean->field_defs as $name => $arr) {

        if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || $arr['type'] == 'id' || $arr['type'] == 'link')) {

            $relationship_field = '$' . $relationship_name . "_" . $name;
            $curNum             = strpos($text, $relationship_field);

            if ($curNum) {
                if ($curNum < $firstNum || $firstNum == 0) {
                    $firstValue = $relationship_field;
                    $firstNum = $curNum;
                }
                if ($curNum > $lastNum) {
                    $lastValue = $relationship_field;
                    $lastNum = $curNum;
                }
            }
        }
    }

    if ($firstValue !== '' && $lastValue !== '') {

        /* Converting Text */
        $tparts = explode($firstValue, $text);
        $temp = $tparts[0];

        /* check if there is only one line item */
        if ($firstNum == $lastNum) {
            $linePart = $firstValue;
        } else {
            $tparts = explode($lastValue, $tparts[1]);
            $linePart = $firstValue . $tparts[0] . $lastValue;
        }

        $tcount = strrpos($temp, $startElement);
        $lsValue = substr($temp, $tcount);
        $tcount = strpos($lsValue, ">") + 1;
        $lsValue = substr($lsValue, 0, $tcount);

        /* Read line end values */
        $tcount = strpos($tparts[1], $endElement) + strlen($endElement);
        $leValue = substr($tparts[1], 0, $tcount);
        $tdTemp = explode($lsValue, $temp);
        $linePart = $lsValue . $tdTemp[count($tdTemp) - 1] . $linePart . $leValue;
        $parts = explode($linePart, $text);

        return array(
            'line_part' => $linePart,
            'parts'     => $parts,
        );
    } 
    else 
    {
        return false;
    }
}

function populate_group_lines($text, $lineItemsGroups, $lineItems, $element = 'table')
{

    $firstValue = '';
    $firstNum = 0;

    $lastValue = '';
    $lastNum = 0;

    $startElement = '<' . $element;
    $endElement = '</' . $element . '>';


    $groups = new AOS_Line_Item_Groups();
    foreach ($groups->field_defs as $name => $arr) {
        if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || $arr['type'] == 'id' || $arr['type'] == 'link')) {

            $curNum = strpos($text, '$aos_line_item_groups_' . $name);
            if ($curNum) {
                if ($curNum < $firstNum || $firstNum == 0) {
                    $firstValue = '$aos_line_item_groups_' . $name;
                    $firstNum = $curNum;
                }
                if ($curNum > $lastNum) {
                    $lastValue = '$aos_line_item_groups_' . $name;
                    $lastNum = $curNum;
                }
            }
        }
    }
    if ($firstValue !== '' && $lastValue !== '') {
        //Converting Text
        $parts = explode($firstValue, $text);
        $text = $parts[0];
        $parts = explode($lastValue, $parts[1]);
        if ($lastValue == $firstValue) {
            $groupPart = $firstValue . $parts[0];
        } else {
            $groupPart = $firstValue . $parts[0] . $lastValue;
        }

        if (count($lineItemsGroups) != 0) {
            //Read line start <tr> value
            $tcount = strrpos($text, $startElement);
            $lsValue = substr($text, $tcount);
            $tcount = strpos($lsValue, ">") + 1;
            $lsValue = substr($lsValue, 0, $tcount);


            //Read line end values
            $tcount = strpos($parts[1], $endElement) + strlen($endElement);
            $leValue = substr($parts[1], 0, $tcount);

            //Converting Line Items
            $obb = array();

            $tdTemp = explode($lsValue, $text);

            $groupPart = $lsValue . $tdTemp[count($tdTemp) - 1] . $groupPart . $leValue;

            $text = $tdTemp[0];

            foreach ($lineItemsGroups as $group_id => $lineItemsArray) {
                $groupPartTemp = populate_product_lines($groupPart, $lineItemsArray);
                $groupPartTemp = populate_service_lines($groupPartTemp, $lineItemsArray);

                $obb['AOS_Line_Item_Groups'] = $group_id;
                $text .= simbaTemplateParser::parse_template($groupPartTemp, $obb);
                $text .= '<br />';
            }
            $tcount = strpos($parts[1], $endElement) + strlen($endElement);
            $parts[1] = substr($parts[1], $tcount);
        } else {
            $tcount = strrpos($text, $startElement);
            $text = substr($text, 0, $tcount);

            $tcount = strpos($parts[1], $endElement) + strlen($endElement);
            $parts[1] = substr($parts[1], $tcount);
        }

        $text .= $parts[1];
    } else {
        $text = populate_product_lines($text, $lineItems);
        $text = populate_service_lines($text, $lineItems);
    }


    return $text;
}

function populate_product_lines($text, $lineItems, $element = 'tr')
{
    $firstValue = '';
    $firstNum = 0;

    $lastValue = '';
    $lastNum = 0;

    $startElement = '<' . $element;
    $endElement = '</' . $element . '>';

    //Find first and last valid line values
    $product_quote = new AOS_Products_Quotes();
    foreach ($product_quote->field_defs as $name => $arr) {
        if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || $arr['type'] == 'id' || $arr['type'] == 'link')) {

            $curNum = strpos($text, '$aos_products_quotes_' . $name);

            if ($curNum) {
                if ($curNum < $firstNum || $firstNum == 0) {
                    $firstValue = '$aos_products_quotes_' . $name;
                    $firstNum = $curNum;

                }
                if ($curNum > $lastNum) {
                    $lastValue = '$aos_products_quotes_' . $name;
                    $lastNum = $curNum;

                }
            }
        }
    }

    $product = new AOS_Products();
    foreach ($product->field_defs as $name => $arr) {
        if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || $arr['type'] == 'id' || $arr['type'] == 'link')) {

            $curNum = strpos($text, '$aos_products_' . $name);
            if ($curNum) {
                if ($curNum < $firstNum || $firstNum == 0) {
                    $firstValue = '$aos_products_' . $name;


                    $firstNum = $curNum;
                }
                if ($curNum > $lastNum) {
                    $lastValue = '$aos_products_' . $name;
                    $lastNum = $curNum;
                }
            }
        }
    }

    if ($firstValue !== '' && $lastValue !== '') {

        //Converting Text
        $tparts = explode($firstValue, $text);
        $temp = $tparts[0];

        //check if there is only one line item
        if ($firstNum == $lastNum) {
            $linePart = $firstValue;
        } else {
            $tparts = explode($lastValue, $tparts[1]);
            $linePart = $firstValue . $tparts[0] . $lastValue;
        }

        $tcount = strrpos($temp, $startElement);
        $lsValue = substr($temp, $tcount);
        $tcount = strpos($lsValue, ">") + 1;
        $lsValue = substr($lsValue, 0, $tcount);

        //Read line end values
        $tcount = strpos($tparts[1], $endElement) + strlen($endElement);
        $leValue = substr($tparts[1], 0, $tcount);
        $tdTemp = explode($lsValue, $temp);

        $linePart = $lsValue . $tdTemp[count($tdTemp) - 1] . $linePart . $leValue;
        $parts = explode($linePart, $text);
        $text = $parts[0];

        //Converting Line Items
        if (count($lineItems) != 0) {
            foreach ($lineItems as $id => $productId) {
                if ($productId != null && $productId != '0') {
                    $obb['AOS_Products_Quotes'] = $id;
                    $obb['AOS_Products'] = $productId;
                    $text .= simbaTemplateParser::parse_template($linePart, $obb);
                }
            }
        }

		for ($i = 1; $i < count($parts); $i++) {
			$text .= $parts[$i];
		}
    }
    return $text;
}

function populate_service_lines($text, $lineItems, $element = 'tr')
{
    $firstValue = '';
    $firstNum = 0;

    $lastValue = '';
    $lastNum = 0;

    $startElement = '<' . $element;
    $endElement = '</' . $element . '>';

    $text = str_replace("\$aos_services_quotes_service", "\$aos_services_quotes_product", $text);

    //Find first and last valid line values
    $product_quote = new AOS_Products_Quotes();
    foreach ($product_quote->field_defs as $name => $arr) {
        if (!((isset($arr['dbType']) && strtolower($arr['dbType']) == 'id') || $arr['type'] == 'id' || $arr['type'] == 'link')) {

            $curNum = strpos($text, '$aos_services_quotes_' . $name);
            if ($curNum) {
                if ($curNum < $firstNum || $firstNum == 0) {
                    $firstValue = '$aos_products_quotes_' . $name;
                    $firstNum = $curNum;
                }
                if ($curNum > $lastNum) {
                    $lastValue = '$aos_products_quotes_' . $name;
                    $lastNum = $curNum;
                }
            }
        }
    }
    if ($firstValue !== '' && $lastValue !== '') {
        $text = str_replace("\$aos_products", "\$aos_null", $text);
        $text = str_replace("\$aos_services", "\$aos_products", $text);

        //Converting Text
        $tparts = explode($firstValue, $text);
        $temp = $tparts[0];

        //check if there is only one line item
        if ($firstNum == $lastNum) {
            $linePart = $firstValue;
        } else {
            $tparts = explode($lastValue, $tparts[1]);
            $linePart = $firstValue . $tparts[0] . $lastValue;
        }

        $tcount = strrpos($temp, $startElement);
        $lsValue = substr($temp, $tcount);
        $tcount = strpos($lsValue, ">") + 1;
        $lsValue = substr($lsValue, 0, $tcount);

        //Read line end values
        $tcount = strpos($tparts[1], $endElement) + strlen($endElement);
        $leValue = substr($tparts[1], 0, $tcount);
        $tdTemp = explode($lsValue, $temp);

        $linePart = $lsValue . $tdTemp[count($tdTemp) - 1] . $linePart . $leValue;
        $parts = explode($linePart, $text);
        $text = $parts[0];

        //Converting Line Items
        if (count($lineItems) != 0) {
            foreach ($lineItems as $id => $productId) {
                if ($productId == null || $productId == '0') {
                    $obb['AOS_Products_Quotes'] = $id;
                    $text .= simbaTemplateParser::parse_template($linePart, $obb);
                }
            }
        }

		for ($i = 1; $i < count($parts); $i++) {
			$text .= $parts[$i];
		}
    }
    return $text;
}