<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

/**
* LICENSE: The contents of this file are subject to the license agreement ("License") which is included
* in the installation package (LICENSE.txt). By installing or using this file, you have unconditionally
* agreed to the terms and conditions of the License, and you may not use this file except in compliance
* with the License.
*
* @author Original Author HP - Simbanic
*/

function writeDefaultTypeForPDFTemplates()
{
	global $app_list_strings, $lang;
	$aListValue                  = array();
	$moduleArray                 = array();
	$i               = 0;
	$flag            = false;
	$defaultModulels = array("AOS_Quotes", "AOS_Invoices", "AOS_Contracts", "Accounts", "Contacts", "Leads");
	foreach ($defaultModulels as $key => $value) {
	    if (!(array_key_exists($value, $moduleArray))) {
	        $dropDownValue       = $app_list_strings['moduleList'][$value];
	        $moduleArray[$value] = $dropDownValue;
	    }
	    $flag = true;
	}

	if ($flag) {

	    foreach ($moduleArray as $key => $value) {
	        $aListValue[$i][0] = $key;
	        $aListValue[$i][1] = $value;
	        $i++;
	    }
		
	    $params['list_value']     = json_encode($aListValue);
	    $params['dropdown_name']  = 'pdf_template_type_dom';
	    $params['dropdown_lang']  = $lang;
	    $_REQUEST['view_package'] = 'studio';

	    require_once "modules/ModuleBuilder/parsers/parser.dropdown.php";
	    $parser                   = new ParserDropDown();
	    $parser->saveDropDown($params);
	}
}

function pre_uninstall()
{
	$filename = 'custom/modules/ModuleBuilder/parsers/parser.simba_enhancedPdf.php';

	if(file_exists($filename))
	{
		require_once $filename;
		
		$parser = new ParserAOS_PDF_Templates(MB_EDITVIEW, 'AOS_PDF_Templates', '');
		$parser->remove();
		$parser->handleSave(false);
	}
	else
	{
		$GLOBALS['log']->fatal('simbaEnhancePDF :: file_not_exist '. print_r("parser.simba_enhancedPdf path: " . $filename, true) . __FILE__ . __LINE__);
	}
	
	writeDefaultTypeForPDFTemplates();
}