<?php 
 $GLOBALS["dictionary"]["T1019_Time_Tracking"]=array (
  'table' => 't1019_time_tracking',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'rname' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'sort_on' => 'last_name',
      'source' => 'non-db',
      'group' => 'last_name',
      'len' => '255',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'importable' => 'false',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 't1019_time_tracking_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 't1019_time_tracking_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 't1019_time_tracking_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_t1019_time_tracking',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'salutation' => 
    array (
      'name' => 'salutation',
      'vname' => 'LBL_SALUTATION',
      'type' => 'enum',
      'options' => 'salutation_dom',
      'massupdate' => false,
      'len' => '255',
      'comment' => 'Contact salutation (e.g., Mr, Ms)',
    ),
    'first_name' => 
    array (
      'name' => 'first_name',
      'vname' => 'LBL_FIRST_NAME',
      'type' => 'varchar',
      'len' => '100',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'First name of the contact',
      'merge_filter' => 'selected',
    ),
    'last_name' => 
    array (
      'name' => 'last_name',
      'vname' => 'LBL_LAST_NAME',
      'type' => 'varchar',
      'len' => '100',
      'unified_search' => false,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'comment' => 'Last name of the contact',
      'merge_filter' => 'disabled',
      'required' => false,
      'importable' => 'required',
      'inline_edit' => true,
      'comments' => 'Last name of the contact',
    ),
    'full_name' => 
    array (
      'name' => 'full_name',
      'rname' => 'full_name',
      'vname' => 'LBL_NAME',
      'type' => 'fullname',
      'fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'sort_on' => 'last_name',
      'source' => 'non-db',
      'group' => 'last_name',
      'len' => '510',
      'db_concat_fields' => 
      array (
        0 => 'first_name',
        1 => 'last_name',
      ),
      'studio' => 
      array (
        'listview' => false,
      ),
    ),
    'title' => 
    array (
      'name' => 'title',
      'vname' => 'LBL_TITLE',
      'type' => 'varchar',
      'len' => '100',
      'comment' => 'The title of the contact',
    ),
    'photo' => 
    array (
      'name' => 'photo',
      'vname' => 'LBL_PHOTO',
      'type' => 'image',
      'massupdate' => false,
      'comments' => '',
      'help' => '',
      'importable' => false,
      'reportable' => true,
      'len' => 255,
      'dbType' => 'varchar',
      'width' => '160',
      'height' => '160',
      'studio' => 
      array (
        'listview' => true,
      ),
    ),
    'department' => 
    array (
      'name' => 'department',
      'vname' => 'LBL_DEPARTMENT',
      'type' => 'varchar',
      'len' => '255',
      'comment' => 'The department of the contact',
      'merge_filter' => 'enabled',
    ),
    'do_not_call' => 
    array (
      'name' => 'do_not_call',
      'vname' => 'LBL_DO_NOT_CALL',
      'type' => 'bool',
      'default' => '0',
      'audited' => true,
      'comment' => 'An indicator of whether contact can be called',
    ),
    'phone_home' => 
    array (
      'name' => 'phone_home',
      'vname' => 'LBL_HOME_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Home phone number of the contact',
      'merge_filter' => 'enabled',
    ),
    'email' => 
    array (
      'name' => 'email',
      'type' => 'email',
      'query_type' => 'default',
      'source' => 'non-db',
      'operator' => 'subquery',
      'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
      'db_field' => 
      array (
        0 => 'id',
      ),
      'vname' => 'LBL_ANY_EMAIL',
      'studio' => 
      array (
        'visible' => false,
        'searchview' => true,
      ),
      'importable' => false,
    ),
    'phone_mobile' => 
    array (
      'name' => 'phone_mobile',
      'vname' => 'LBL_MOBILE_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Mobile phone number of the contact',
      'merge_filter' => 'enabled',
    ),
    'phone_work' => 
    array (
      'name' => 'phone_work',
      'vname' => 'LBL_OFFICE_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'audited' => true,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Work phone number of the contact',
      'merge_filter' => 'enabled',
    ),
    'phone_other' => 
    array (
      'name' => 'phone_other',
      'vname' => 'LBL_OTHER_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Other phone number for the contact',
      'merge_filter' => 'enabled',
    ),
    'phone_fax' => 
    array (
      'name' => 'phone_fax',
      'vname' => 'LBL_FAX_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Contact fax number',
      'merge_filter' => 'enabled',
    ),
    'email1' => 
    array (
      'name' => 'email1',
      'vname' => 'LBL_EMAIL_ADDRESS',
      'type' => 'varchar',
      'function' => 
      array (
        'name' => 'getEmailAddressWidget',
        'returns' => 'html',
      ),
      'source' => 'non-db',
      'group' => 'email1',
      'merge_filter' => 'enabled',
      'studio' => 
      array (
        'editview' => true,
        'editField' => true,
        'searchview' => false,
        'popupsearch' => false,
      ),
      'full_text_search' => 
      array (
        'boost' => 3,
        'analyzer' => 'whitespace',
      ),
    ),
    'email2' => 
    array (
      'name' => 'email2',
      'vname' => 'LBL_OTHER_EMAIL_ADDRESS',
      'type' => 'varchar',
      'function' => 
      array (
        'name' => 'getEmailAddressWidget',
        'returns' => 'html',
      ),
      'source' => 'non-db',
      'group' => 'email2',
      'merge_filter' => 'enabled',
      'studio' => 'false',
    ),
    'invalid_email' => 
    array (
      'name' => 'invalid_email',
      'vname' => 'LBL_INVALID_EMAIL',
      'source' => 'non-db',
      'type' => 'bool',
      'massupdate' => false,
      'studio' => 'false',
    ),
    'email_opt_out' => 
    array (
      'name' => 'email_opt_out',
      'vname' => 'LBL_EMAIL_OPT_OUT',
      'source' => 'non-db',
      'type' => 'bool',
      'massupdate' => false,
      'studio' => 'false',
    ),
    'lawful_basis' => 
    array (
      'name' => 'lawful_basis',
      'vname' => 'LBL_LAWFUL_BASIS',
      'type' => 'multienum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'inline_edit' => true,
      'reportable' => true,
      'merge_filter' => 'enabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lawful_basis_dom',
      'audited' => true,
      'importable' => true,
    ),
    'date_reviewed' => 
    array (
      'name' => 'date_reviewed',
      'vname' => 'LBL_DATE_REVIEWED',
      'type' => 'date',
      'massupdate' => true,
      'audited' => true,
      'importable' => true,
    ),
    'lawful_basis_source' => 
    array (
      'name' => 'lawful_basis_source',
      'vname' => 'LBL_LAWFUL_BASIS_SOURCE',
      'type' => 'enum',
      'massupdate' => true,
      'no_default' => false,
      'comments' => '',
      'inline_edit' => true,
      'reportable' => true,
      'merge_filter' => 'enabled',
      'len' => 100,
      'size' => '20',
      'options' => 'lawful_basis_source_dom',
      'audited' => true,
      'importable' => true,
    ),
    'primary_address_street' => 
    array (
      'name' => 'primary_address_street',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'group' => 'primary_address',
      'comment' => 'Street address for primary address',
      'merge_filter' => 'enabled',
    ),
    'primary_address_street_2' => 
    array (
      'name' => 'primary_address_street_2',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'primary_address_street_3' => 
    array (
      'name' => 'primary_address_street_3',
      'vname' => 'LBL_PRIMARY_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'primary_address_city' => 
    array (
      'name' => 'primary_address_city',
      'vname' => 'LBL_PRIMARY_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'primary_address',
      'comment' => 'City for primary address',
      'merge_filter' => 'enabled',
    ),
    'primary_address_state' => 
    array (
      'name' => 'primary_address_state',
      'vname' => 'LBL_PRIMARY_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'primary_address',
      'comment' => 'State for primary address',
      'merge_filter' => 'enabled',
    ),
    'primary_address_postalcode' => 
    array (
      'name' => 'primary_address_postalcode',
      'vname' => 'LBL_PRIMARY_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'primary_address',
      'comment' => 'Postal code for primary address',
      'merge_filter' => 'enabled',
    ),
    'primary_address_country' => 
    array (
      'name' => 'primary_address_country',
      'vname' => 'LBL_PRIMARY_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'primary_address',
      'comment' => 'Country for primary address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_street' => 
    array (
      'name' => 'alt_address_street',
      'vname' => 'LBL_ALT_ADDRESS_STREET',
      'type' => 'varchar',
      'len' => '150',
      'group' => 'alt_address',
      'comment' => 'Street address for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_street_2' => 
    array (
      'name' => 'alt_address_street_2',
      'vname' => 'LBL_ALT_ADDRESS_STREET_2',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'alt_address_street_3' => 
    array (
      'name' => 'alt_address_street_3',
      'vname' => 'LBL_ALT_ADDRESS_STREET_3',
      'type' => 'varchar',
      'len' => '150',
      'source' => 'non-db',
    ),
    'alt_address_city' => 
    array (
      'name' => 'alt_address_city',
      'vname' => 'LBL_ALT_ADDRESS_CITY',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'alt_address',
      'comment' => 'City for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_state' => 
    array (
      'name' => 'alt_address_state',
      'vname' => 'LBL_ALT_ADDRESS_STATE',
      'type' => 'varchar',
      'len' => '100',
      'group' => 'alt_address',
      'comment' => 'State for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_postalcode' => 
    array (
      'name' => 'alt_address_postalcode',
      'vname' => 'LBL_ALT_ADDRESS_POSTALCODE',
      'type' => 'varchar',
      'len' => '20',
      'group' => 'alt_address',
      'comment' => 'Postal code for alternate address',
      'merge_filter' => 'enabled',
    ),
    'alt_address_country' => 
    array (
      'name' => 'alt_address_country',
      'vname' => 'LBL_ALT_ADDRESS_COUNTRY',
      'type' => 'varchar',
      'group' => 'alt_address',
      'comment' => 'Country for alternate address',
      'merge_filter' => 'enabled',
    ),
    'assistant' => 
    array (
      'name' => 'assistant',
      'vname' => 'LBL_ASSISTANT',
      'type' => 'varchar',
      'len' => '75',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 2,
      ),
      'comment' => 'Name of the assistant of the contact',
      'merge_filter' => 'enabled',
    ),
    'assistant_phone' => 
    array (
      'name' => 'assistant_phone',
      'vname' => 'LBL_ASSISTANT_PHONE',
      'type' => 'phone',
      'dbType' => 'varchar',
      'len' => 100,
      'group' => 'assistant',
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 1,
      ),
      'comment' => 'Phone number of the assistant of the contact',
      'merge_filter' => 'enabled',
    ),
    'email_addresses_primary' => 
    array (
      'name' => 'email_addresses_primary',
      'type' => 'link',
      'relationship' => 't1019_time_tracking_email_addresses_primary',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESS_PRIMARY',
      'duplicate_merge' => 'disabled',
    ),
    'email_addresses' => 
    array (
      'name' => 'email_addresses',
      'type' => 'link',
      'relationship' => 't1019_time_tracking_email_addresses',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_ADDRESSES',
      'reportable' => false,
      'unified_search' => true,
      'rel_fields' => 
      array (
        'primary_address' => 
        array (
          'type' => 'bool',
        ),
      ),
    ),
    'email_addresses_non_primary' => 
    array (
      'name' => 'email_addresses_non_primary',
      'type' => 'email',
      'source' => 'non-db',
      'vname' => 'LBL_EMAIL_NON_PRIMARY',
      'studio' => false,
      'reportable' => false,
      'massupdate' => false,
    ),
    'accounts_t1019_time_tracking_1' => 
    array (
      'name' => 'accounts_t1019_time_tracking_1',
      'type' => 'link',
      'relationship' => 'accounts_t1019_time_tracking_1',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_ACCOUNTS_T1019_TIME_TRACKING_1_FROM_ACCOUNTS_TITLE',
      'id_name' => 'accounts_t1019_time_tracking_1accounts_ida',
    ),
    'accounts_t1019_time_tracking_1_name' => 
    array (
      'name' => 'accounts_t1019_time_tracking_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_ACCOUNTS_T1019_TIME_TRACKING_1_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'accounts_t1019_time_tracking_1accounts_ida',
      'link' => 'accounts_t1019_time_tracking_1',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'accounts_t1019_time_tracking_1accounts_ida' => 
    array (
      'name' => 'accounts_t1019_time_tracking_1accounts_ida',
      'type' => 'link',
      'relationship' => 'accounts_t1019_time_tracking_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_ACCOUNTS_T1019_TIME_TRACKING_1_FROM_T1019_TIME_TRACKING_TITLE',
    ),
    'ca09_casenb_t1019_time_tracking_1' => 
    array (
      'name' => 'ca09_casenb_t1019_time_tracking_1',
      'type' => 'link',
      'relationship' => 'ca09_casenb_t1019_time_tracking_1',
      'source' => 'non-db',
      'module' => 'Ca09_Casenb',
      'bean_name' => 'Ca09_Casenb',
      'vname' => 'LBL_CA09_CASENB_T1019_TIME_TRACKING_1_FROM_CA09_CASENB_TITLE',
      'id_name' => 'ca09_casenb_t1019_time_tracking_1ca09_casenb_ida',
    ),
    'ca09_casenb_t1019_time_tracking_1_name' => 
    array (
      'name' => 'ca09_casenb_t1019_time_tracking_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_CA09_CASENB_T1019_TIME_TRACKING_1_FROM_CA09_CASENB_TITLE',
      'save' => true,
      'id_name' => 'ca09_casenb_t1019_time_tracking_1ca09_casenb_ida',
      'link' => 'ca09_casenb_t1019_time_tracking_1',
      'table' => 'ca09_casenb',
      'module' => 'Ca09_Casenb',
      'rname' => 'name',
    ),
    'ca09_casenb_t1019_time_tracking_1ca09_casenb_ida' => 
    array (
      'name' => 'ca09_casenb_t1019_time_tracking_1ca09_casenb_ida',
      'type' => 'link',
      'relationship' => 'ca09_casenb_t1019_time_tracking_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_CA09_CASENB_T1019_TIME_TRACKING_1_FROM_T1019_TIME_TRACKING_TITLE',
    ),
    'sla19_sla_t1019_time_tracking_1' => 
    array (
      'name' => 'sla19_sla_t1019_time_tracking_1',
      'type' => 'link',
      'relationship' => 'sla19_sla_t1019_time_tracking_1',
      'source' => 'non-db',
      'module' => 'SLA19_SLA',
      'bean_name' => 'SLA19_SLA',
      'vname' => 'LBL_SLA19_SLA_T1019_TIME_TRACKING_1_FROM_SLA19_SLA_TITLE',
      'id_name' => 'sla19_sla_t1019_time_tracking_1sla19_sla_ida',
    ),
    'sla19_sla_t1019_time_tracking_1_name' => 
    array (
      'name' => 'sla19_sla_t1019_time_tracking_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SLA19_SLA_T1019_TIME_TRACKING_1_FROM_SLA19_SLA_TITLE',
      'save' => true,
      'id_name' => 'sla19_sla_t1019_time_tracking_1sla19_sla_ida',
      'link' => 'sla19_sla_t1019_time_tracking_1',
      'table' => 'sla19_sla',
      'module' => 'SLA19_SLA',
      'rname' => 'name',
    ),
    'sla19_sla_t1019_time_tracking_1sla19_sla_ida' => 
    array (
      'name' => 'sla19_sla_t1019_time_tracking_1sla19_sla_ida',
      'type' => 'link',
      'relationship' => 'sla19_sla_t1019_time_tracking_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_SLA19_SLA_T1019_TIME_TRACKING_1_FROM_T1019_TIME_TRACKING_TITLE',
    ),
    'srs03_servicerecordsheet_t1019_time_tracking_1' => 
    array (
      'name' => 'srs03_servicerecordsheet_t1019_time_tracking_1',
      'type' => 'link',
      'relationship' => 'srs03_servicerecordsheet_t1019_time_tracking_1',
      'source' => 'non-db',
      'module' => 'srs03_Servicerecordsheet',
      'bean_name' => 'srs03_Servicerecordsheet',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_T1019_TIME_TRACKING_1_FROM_SRS03_SERVICERECORDSHEET_TITLE',
      'id_name' => 'srs03_serva091rdsheet_ida',
    ),
    'srs03_servicerecordsheet_t1019_time_tracking_1_name' => 
    array (
      'name' => 'srs03_servicerecordsheet_t1019_time_tracking_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_T1019_TIME_TRACKING_1_FROM_SRS03_SERVICERECORDSHEET_TITLE',
      'save' => true,
      'id_name' => 'srs03_serva091rdsheet_ida',
      'link' => 'srs03_servicerecordsheet_t1019_time_tracking_1',
      'table' => 'srs03_servicerecordsheet',
      'module' => 'srs03_Servicerecordsheet',
      'rname' => 'name',
    ),
    'srs03_serva091rdsheet_ida' => 
    array (
      'name' => 'srs03_serva091rdsheet_ida',
      'type' => 'link',
      'relationship' => 'srs03_servicerecordsheet_t1019_time_tracking_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_T1019_TIME_TRACKING_1_FROM_T1019_TIME_TRACKING_TITLE',
    ),
    'pt1_projecttracking_t1019_time_tracking_1' => 
    array (
      'name' => 'pt1_projecttracking_t1019_time_tracking_1',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_t1019_time_tracking_1',
      'source' => 'non-db',
      'module' => 'pt1_ProjectTracking',
      'bean_name' => 'pt1_ProjectTracking',
      'vname' => 'LBL_PT1_PROJECTTRACKING_T1019_TIME_TRACKING_1_FROM_PT1_PROJECTTRACKING_TITLE',
      'id_name' => 'pt1_projecttracking_t1019_time_tracking_1pt1_projecttracking_ida',
    ),
    'pt1_projecttracking_t1019_time_tracking_1_name' => 
    array (
      'name' => 'pt1_projecttracking_t1019_time_tracking_1_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PT1_PROJECTTRACKING_T1019_TIME_TRACKING_1_FROM_PT1_PROJECTTRACKING_TITLE',
      'save' => true,
      'id_name' => 'pt1_projecttracking_t1019_time_tracking_1pt1_projecttracking_ida',
      'link' => 'pt1_projecttracking_t1019_time_tracking_1',
      'table' => 'pt1_projecttracking',
      'module' => 'pt1_ProjectTracking',
      'rname' => 'name',
    ),
    'pt1_projecttracking_t1019_time_tracking_1pt1_projecttracking_ida' => 
    array (
      'name' => 'pt1_projecttracking_t1019_time_tracking_1pt1_projecttracking_ida',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_t1019_time_tracking_1',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_PT1_PROJECTTRACKING_T1019_TIME_TRACKING_1_FROM_T1019_TIME_TRACKING_TITLE',
    ),
    'technician_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Technician',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'technician_c',
      'vname' => 'LBL_TECHNICIAN',
      'type' => 'enum',
      'massupdate' => '1',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'technician_list',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'T1019_Time_Trackingtechnician_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'workcode_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Workcode',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'workcode_c',
      'vname' => 'LBL_WORKCODE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Workcode',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'T1019_Time_Trackingworkcode_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'hoursused_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Hours used',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'hoursused_c',
      'vname' => 'LBL_HOURSUSED',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'T1019_Time_Trackinghoursused_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'hoursold_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Hours sold',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'hoursold_c',
      'vname' => 'LBL_HOURSOLD',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'T1019_Time_Trackinghoursold_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'hourschargeable_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Hours Chargeable',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'hourschargeable_c',
      'vname' => 'LBL_HOURSCHARGEABLE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'T1019_Time_Trackinghourschargeable_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'chargeable_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Chargeable',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'chargeable_c',
      'vname' => 'LBL_CHARGEABLE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Chargeable',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'T1019_Time_Trackingchargeable_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'invoiced_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Invoiced',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'invoiced_c',
      'vname' => 'LBL_INVOICED',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'NO',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Invoiced',
      'studio' => 'visible',
      'dependency' => NULL,
      'id' => 'T1019_Time_Trackinginvoiced_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'workdate_c' => 
    array (
      'inline_edit' => '1',
      'options' => 'date_range_search_dom',
      'labelValue' => 'Work date',
      'enable_range_search' => '1',
      'required' => true,
      'source' => 'custom_fields',
      'name' => 'workdate_c',
      'vname' => 'LBL_WORKDATE',
      'type' => 'date',
      'massupdate' => '1',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'display_default' => 'now',
      'id' => 'T1019_Time_Trackingworkdate_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'srs03_servicerecordsheet_t1019_time_tracking_2' => 
    array (
      'name' => 'srs03_servicerecordsheet_t1019_time_tracking_2',
      'type' => 'link',
      'relationship' => 'srs03_servicerecordsheet_t1019_time_tracking_2',
      'source' => 'non-db',
      'module' => 'srs03_Servicerecordsheet',
      'bean_name' => 'srs03_Servicerecordsheet',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_T1019_TIME_TRACKING_2_FROM_SRS03_SERVICERECORDSHEET_TITLE',
      'id_name' => 'srs03_servfd02rdsheet_ida',
    ),
    'srs03_servicerecordsheet_t1019_time_tracking_2_name' => 
    array (
      'name' => 'srs03_servicerecordsheet_t1019_time_tracking_2_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_T1019_TIME_TRACKING_2_FROM_SRS03_SERVICERECORDSHEET_TITLE',
      'save' => true,
      'id_name' => 'srs03_servfd02rdsheet_ida',
      'link' => 'srs03_servicerecordsheet_t1019_time_tracking_2',
      'table' => 'srs03_servicerecordsheet',
      'module' => 'srs03_Servicerecordsheet',
      'rname' => 'name',
    ),
    'srs03_servfd02rdsheet_ida' => 
    array (
      'name' => 'srs03_servfd02rdsheet_ida',
      'type' => 'link',
      'relationship' => 'srs03_servicerecordsheet_t1019_time_tracking_2',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_SRS03_SERVICERECORDSHEET_T1019_TIME_TRACKING_2_FROM_T1019_TIME_TRACKING_TITLE',
    ),
    'srs03_servicerecordsheet_id1_c' => 
    array (
      'inline_edit' => 1,
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'srs03_servicerecordsheet_id1_c',
      'vname' => 'LBL_SRS_SRS03_SERVICERECORDSHEET_ID',
      'type' => 'id',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '36',
      'size' => '20',
      'id' => 'T1019_Time_Trackingsrs03_servicerecordsheet_id1_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
    'srs_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'SRS',
      'required' => false,
      'source' => 'non-db',
      'name' => 'srs_c',
      'vname' => 'LBL_SRS',
      'type' => 'relate',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'enabled',
      'duplicate_merge_dom_value' => '1',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'srs03_servicerecordsheet_id1_c',
      'ext2' => 'srs03_Servicerecordsheet',
      'module' => 'srs03_Servicerecordsheet',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
      'id' => 'T1019_Time_Trackingsrs_c',
      'custom_module' => 'T1019_Time_Tracking',
    ),
  ),
  'relationships' => 
  array (
    't1019_time_tracking_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'T1019_Time_Tracking',
      'rhs_table' => 't1019_time_tracking',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    't1019_time_tracking_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'T1019_Time_Tracking',
      'rhs_table' => 't1019_time_tracking',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    't1019_time_tracking_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'T1019_Time_Tracking',
      'rhs_table' => 't1019_time_tracking',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_t1019_time_tracking' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'T1019_Time_Tracking',
      'rhs_table' => 't1019_time_tracking',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'T1019_Time_Tracking',
    ),
    't1019_time_tracking_email_addresses' => 
    array (
      'lhs_module' => 'T1019_Time_Tracking',
      'lhs_table' => 't1019_time_tracking',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'bean_module',
      'relationship_role_column_value' => 'T1019_Time_Tracking',
    ),
    't1019_time_tracking_email_addresses_primary' => 
    array (
      'lhs_module' => 'T1019_Time_Tracking',
      'lhs_table' => 't1019_time_tracking',
      'lhs_key' => 'id',
      'rhs_module' => 'EmailAddresses',
      'rhs_table' => 'email_addresses',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'email_addr_bean_rel',
      'join_key_lhs' => 'bean_id',
      'join_key_rhs' => 'email_address_id',
      'relationship_role_column' => 'primary_address',
      'relationship_role_column_value' => '1',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 't1019_time_trackingpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'person' => 'person',
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);