<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_Dfareporting_CreativeOptimizationConfiguration extends Google_Collection
{
  protected $collection_key = 'optimizationActivitys';
  public $id;
  public $name;
  protected $optimizationActivitysType = 'Google_Service_Dfareporting_OptimizationActivity';
  protected $optimizationActivitysDataType = 'array';
  public $optimizationModel;

  public function setId($id)
  {
    $this->id = $id;
  }
  public function getId()
  {
    return $this->id;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param Google_Service_Dfareporting_OptimizationActivity
   */
  public function setOptimizationActivitys($optimizationActivitys)
  {
    $this->optimizationActivitys = $optimizationActivitys;
  }
  /**
   * @return Google_Service_Dfareporting_OptimizationActivity
   */
  public function getOptimizationActivitys()
  {
    return $this->optimizationActivitys;
  }
  public function setOptimizationModel($optimizationModel)
  {
    $this->optimizationModel = $optimizationModel;
  }
  public function getOptimizationModel()
  {
    return $this->optimizationModel;
  }
}
