<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2020 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');

}

require_once(clean_path($unzip_dir . '/scripts/upgrade_utils.php'));

function post_install()
{
    _logThis('Running post_install.');

    global $unzip_dir;
    global $sugar_version;
    global $_SESSION;

    require_once('install/seed_data/Advanced_Password_SeedData.php');
    require_once('install/suite_install/SystemEmailTemplates.php');
    upgradeSystemEmailTemplates();
    setSystemEmailTemplatesDefaultConfig();

    _logThis('Update Config');
    updateConfig();

    if (!isset($_SESSION['sqlSkippedQueries'])) {
        $_SESSION['sqlSkippedQueries'] = array();
    }
    initialize_session_vars();
    if (!isset($unzip_dir) || $unzip_dir == null) {
        $unzip_dir = $_SESSION['unzip_dir'];
    }



    //PUT DATABASE UPGRADE SCRIPT HANDLING HERE
    $new_sugar_version = getUpgradeVersion();

    $post_action = status_post_install_action('sql_query');
    if ($post_action != null) {
        if ($post_action !== 'done') {
            //continue from where left in previous run
            runSqlFiles($sugar_version, $new_sugar_version, 'sql_query', $post_action);
            $currProg['sql_query'] = 'done';
            post_install_progress($currProg, 'set');
        }
    } else {
        //never ran before
        runSqlFiles($sugar_version, $new_sugar_version, 'sql_query');
        $currProg['sql_query'] = 'done';
        post_install_progress($currProg, 'set');
    }

    genericFunctions();

    upgradeDbAndFileVersion($new_sugar_version);

    //Remove jssource/src_files sub-directories if they still exist
    $jssource_dirs = array(
        'jssource/src_files/include/javascript/ext-2.0',
        'jssource/src_files/include/javascript/ext-1.1.1',
        'jssource/src_files/include/javascript/yui'
    );

    foreach ($jssource_dirs as $js_dir) {
        if (file_exists($js_dir)) {
            _logThis("Remove {$js_dir} directory");
            rmdir_recursive($js_dir);
            _logThis("Finished removing {$js_dir} directory");
        }
    }


    ///////////////////////////////////////////////////////////////////////////
    ////	Rebuild the necessary group js files...

    _logThis('rebuild grouping js files..');

    $files = array('cache/include/javascript/sugar_grp1.js');
    foreach ($files as $file) {
        _logThis('unlink: ' . $file);
        unlink($file);
    }
    _logThis('cwd: ' . getcwd());
    require_once('jssource/minify_utils.php');
    ConcatenateFiles('.');

    // Bug fix Chicken and Egg issue with files Sugar includes first in uw_utils.php only for 7.9.0
    $from_dir = $unzip_dir . '/scripts/files_to_add_post';

    $files[] = $from_dir . '/include/';
    $files[] = $from_dir . '/modules/';
    $files[] = $from_dir . '/themes/';

    foreach ($files as $file) {
        $destFile = str_replace($from_dir . '/', '', $file);
        if (!is_dir(dirname($destFile))) {
            mkdir_recursive(dirname($destFile)); // make sure the directory exists
        }

        if (stripos($file, 'uw_main.tpl') !== false) {
            _logThis('Skipping "' . $file . '" - file copy will during commit step.');
        } else {
            _logThis('updating UpgradeWizard code post install from: ' . $file);
            _logThis('updating UpgradeWizard code post install: ' . $destFile);
            copy_recursive($file, $destFile);
        }

    }

}

function updateConfig()
{
    global $sugar_config;

    $sugar_config['suitecrm_version'] = '7.14.0';

    if (!isset($sugar_config['email_enable_auto_send_opt_in'])) {
        $sugar_config['email_enable_auto_send_opt_in'] = true;
    }
    if (!isset($sugar_config['email_enable_confirm_opt_in'])) {
        $sugar_config['email_enable_confirm_opt_in'] = 'not-opt-in';
    }
    if (!isset($sugar_config['search']['controller'])) {
        $sugar_config['search']['controller'] = 'UnifiedSearch';
    }
    if (!isset($sugar_config['search']['defaultEngine'])) {
        $sugar_config['search']['defaultEngine'] = 'BasicSearchEngine';
    }

    if (!isset($sugar_config['legacy_email_behaviour'])) {
        $sugar_config['legacy_email_behaviour'] = true;
    }

    if (!isset($sugar_config['pdf']['defaultEngine'])) {
        $sugar_config['pdf']['defaultEngine'] = 'TCPDFEngine';
    } elseif ($sugar_config['pdf']['defaultEngine'] === 'MPDFEngine') {
        $sugar_config['pdf']['defaultEngine'] = 'LegacyMPDFEngine';
    }
    if (!isset($sugar_config['imap_test'])) {
        $sugar_config['imap_test'] = false;
    }
    if (!isset($sugar_config['strict_id_validation'])) {
        $sugar_config['strict_id_validation'] = false;
    }

    if (!isset($sugar_config['valid_image_ext'])) {
        $sugar_config['valid_image_ext'] = ['gif',
            'png',
            'jpg',
            'jpeg',
            'svg',
            'bmp'];
    }

    if (!isset($sugar_config['upload_bad_ext'])){
        $sugar_config['upload_bad_ext'] = ['php',
            'php3',
            'php4',
            'php5',
            'php6',
            'php7',
            'php8',
            'pl',
            'cgi',
            'py',
            'asp',
            'cfm',
            'js',
            'vbs',
            'html',
            'htm',
            'phtml',
            'phar',];
    }

    if (!isset($sugar_config['oauth2_encryption_key'])) {
        try {
            $sugar_config['oauth2_encryption_key'] = base64_encode(random_bytes(32));
        } catch (Exception $e) {
            _logThis('Could not set oauth2_encryption_key : ' . $e->getMessage());
        }
    }

    if (isset($sugar_config['default_number_grouping_separator'])) {
        if (!isset($sugar_config['default_number_grouping_seperator'])) {
            $sugar_config['default_number_grouping_seperator'] = $sugar_config['default_number_grouping_separator'];
        }
        unset($sugar_config['default_number_grouping_separator']);
    }

    if (isset($sugar_config['default_decimal_separator'])) {
        if (!isset($sugar_config['default_decimal_seperator'])) {
            $sugar_config['default_decimal_seperator'] = $sugar_config['default_decimal_separator'];
        }
        unset($sugar_config['default_decimal_separator']);
    }



    ksort($sugar_config);
    write_array_to_file('sugar_config', $sugar_config, 'config.php');
}

/**
 * @param $action
 * @return mixed|string
 */
function status_post_install_action($action)
{
    $currProg = post_install_progress();
    if (is_array($currProg) && $currProg != null) {
        foreach ($currProg as $key => $val) {
            if ($key == $action) {
                return $val;
            }
        }
    }

    return '';
}


