<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2020 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

require_once 'modules/UpgradeWizard/UpgradeRemoval.php';

/**
 * Class UpgradeRemoval65x
 */
class UpgradeRemoval65x extends UpgradeRemoval
{
    /**
     * @var string minimal version for removal
     */
    public $version = '6.5.0';

    /**
     * getFilesToRemove
     * Return an array of files/directories to remove for 65x upgrades
     *
     * @param string $version
     *
     * @return array
     */
    public function getFilesToRemove($version)
    {
        return [
            '.pullapprove.yml',
            'codeception.yml',
            'include/HTMLPurifier/CREDITS',
            'include/HTMLPurifier/HTMLPurifier.autoload.php',
            'include/HTMLPurifier/HTMLPurifier.standalone.php',
            'include/HTMLPurifier/LICENSE',
            'include/HTMLPurifier/VERSION',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Builder/ConfigSchema.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Builder/Xml.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Exception.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Interchange.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Interchange/Directive.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Interchange/Id.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/InterchangeBuilder.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/Validator.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/ValidatorAtom.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema.ser',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.AllowedClasses.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.AllowedFrameTargets.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.AllowedRel.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.AllowedRev.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.ClassUseCDATA.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.DefaultImageAlt.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.DefaultInvalidImage.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.DefaultInvalidImageAlt.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.DefaultTextDir.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.EnableID.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.ForbiddenClasses.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.IDBlacklist.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.IDBlacklistRegexp.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.IDPrefix.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Attr.IDPrefixLocal.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.AutoParagraph.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.Custom.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.DisplayLinkURI.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.Linkify.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.PurifierLinkify.DocURL.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.PurifierLinkify.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.RemoveEmpty.RemoveNbsp.Exceptions.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.RemoveEmpty.RemoveNbsp.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.RemoveEmpty.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/AutoFormat.RemoveSpansWithoutAttributes.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.AllowImportant.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.AllowTricky.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.AllowedFonts.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.AllowedProperties.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.DefinitionRev.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.ForbiddenProperties.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.MaxImgLength.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.Proprietary.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/CSS.Trusted.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Cache.DefinitionImpl.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Cache.SerializerPath.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Cache.SerializerPermissions.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.AggressivelyFixLt.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.CollectErrors.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.ColorKeywords.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.ConvertDocumentToFragment.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.DirectLexLineNumberSyncInterval.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.Encoding.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.EscapeInvalidChildren.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.EscapeInvalidTags.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.EscapeNonASCIICharacters.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.HiddenElements.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.Language.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.LexerImpl.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.MaintainLineNumbers.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.NormalizeNewlines.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.RemoveInvalidImg.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.RemoveProcessingInstructions.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Core.RemoveScriptContents.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Filter.Custom.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Filter.ExtractStyleBlocks.Escaping.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Filter.ExtractStyleBlocks.Scope.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Filter.ExtractStyleBlocks.TidyImpl.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Filter.ExtractStyleBlocks.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Filter.YouTube.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Allowed.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.AllowedAttributes.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.AllowedElements.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.AllowedModules.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Attr.Name.UseCDATA.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.BlockWrapper.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.CoreModules.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.CustomDoctype.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.DefinitionID.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.DefinitionRev.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Doctype.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.FlashAllowFullScreen.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.ForbiddenAttributes.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.ForbiddenElements.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.MaxImgLength.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Nofollow.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Parent.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Proprietary.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.SafeEmbed.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.SafeObject.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Strict.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.TidyAdd.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.TidyLevel.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.TidyRemove.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.Trusted.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/HTML.XHTML.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Output.CommentScriptContents.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Output.FixInnerHTML.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Output.FlashCompat.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Output.Newline.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Output.SortAttr.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Output.TidyFormat.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/Test.ForceNoIconv.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.AllowedSchemes.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.Base.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.DefaultScheme.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.DefinitionID.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.DefinitionRev.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.Disable.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.DisableExternal.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.DisableExternalResources.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.DisableResources.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.Host.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.HostBlacklist.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.MakeAbsolute.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.Munge.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.MungeResources.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.MungeSecretKey.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/URI.OverrideAllowedSchemes.txt',
            'include/HTMLPurifier/standalone/HTMLPurifier/ConfigSchema/schema/info.ini',
            'include/HTMLPurifier/standalone/HTMLPurifier/DefinitionCache/Serializer/.gitkeep',
            'include/HTMLPurifier/standalone/HTMLPurifier/EntityLookup/entities.ser',
            'include/HTMLPurifier/standalone/HTMLPurifier/Filter/ExtractStyleBlocks.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Filter/YouTube.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Language/classes/en-x-test.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Language/messages/en-x-test.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Language/messages/en-x-testmini.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Language/messages/en.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Lexer/PEARSax3.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Lexer/PH5P.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Printer.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Printer/CSSDefinition.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Printer/ConfigForm.css',
            'include/HTMLPurifier/standalone/HTMLPurifier/Printer/ConfigForm.js',
            'include/HTMLPurifier/standalone/HTMLPurifier/Printer/ConfigForm.php',
            'include/HTMLPurifier/standalone/HTMLPurifier/Printer/HTMLDefinition.php',
            'include/Pear/XML_HTMLSax3/HTMLSax3.php',
            'include/Pear/XML_HTMLSax3/HTMLSax3/Decorators.php',
            'include/Pear/XML_HTMLSax3/HTMLSax3/States.php',
            'include/Pear/XML_HTMLSax3/LICENSE',
            'include/Smarty/COPYING.lib',
            'include/Smarty/Config_File.class.php',
            'include/Smarty/LICENSE',
            'include/Smarty/README',
            'include/Smarty/Smarty.class.php',
            'include/Smarty/Smarty_Compiler.class.php',
            'include/Smarty/debug.tpl',
            'include/Smarty/internals/core.assemble_plugin_filepath.php',
            'include/Smarty/internals/core.assign_smarty_interface.php',
            'include/Smarty/internals/core.create_dir_structure.php',
            'include/Smarty/internals/core.display_debug_console.php',
            'include/Smarty/internals/core.get_include_path.php',
            'include/Smarty/internals/core.get_microtime.php',
            'include/Smarty/internals/core.get_php_resource.php',
            'include/Smarty/internals/core.is_secure.php',
            'include/Smarty/internals/core.is_trusted.php',
            'include/Smarty/internals/core.load_plugins.php',
            'include/Smarty/internals/core.load_resource_plugin.php',
            'include/Smarty/internals/core.process_cached_inserts.php',
            'include/Smarty/internals/core.process_compiled_include.php',
            'include/Smarty/internals/core.read_cache_file.php',
            'include/Smarty/internals/core.rm_auto.php',
            'include/Smarty/internals/core.rmdir.php',
            'include/Smarty/internals/core.run_insert_handler.php',
            'include/Smarty/internals/core.smarty_include_php.php',
            'include/Smarty/internals/core.write_cache_file.php',
            'include/Smarty/internals/core.write_compiled_include.php',
            'include/Smarty/internals/core.write_compiled_resource.php',
            'include/Smarty/internals/core.write_file.php',
            'include/StateChecker.php',
            'include/StateCheckerConfig.php',
            'include/StateCheckerTrait.php',
            'include/StateSaver.php',
            'include/SugarCharts/Jit/FlashCanvas/canvas2png.js',
            'include/SugarCharts/Jit/FlashCanvas/flashcanvas.js',
            'include/SugarCharts/Jit/FlashCanvas/flashcanvas.swf',
            'include/SugarCharts/Jit/FlashCanvas/proxy.php',
            'include/SugarCharts/Jit/FlashCanvas/save.php',
            'include/SugarXHprof/SugarXHprof.php',
            'include/SugarXHprof/xhprof_lib/display/typeahead_common.php',
            'include/SugarXHprof/xhprof_lib/display/xhprof.php',
            'include/SugarXHprof/xhprof_lib/utils/callgraph_utils.php',
            'include/SugarXHprof/xhprof_lib/utils/xhprof_lib.php',
            'include/SugarXHprof/xhprof_lib/utils/xhprof_runs.php',
            'include/database/DBHelper.php',
            'include/database/FreeTDSHelper.php',
            'include/database/MssqlHelper.php',
            'include/database/MysqlHelper.php',
            'include/javascript/jquery.js',
            'include/javascript/jquery/jquery.js',
            'include/javascript/jstree/.gitignore',
            'include/javascript/jstree/bower.json',
            'include/javascript/jstree/component.json',
            'include/javascript/jstree/composer.json',
            'include/javascript/jstree/demo/README.md',
            'include/javascript/jstree/demo/basic/index.html',
            'include/javascript/jstree/demo/basic/root.json',
            'include/javascript/jstree/dist/jstree.min.js',
            'include/javascript/jstree/dist/themes/default-dark/32px.png',
            'include/javascript/jstree/dist/themes/default-dark/40px.png',
            'include/javascript/jstree/dist/themes/default-dark/style.css',
            'include/javascript/jstree/dist/themes/default-dark/style.min.css',
            'include/javascript/jstree/dist/themes/default-dark/throbber.gif',
            'include/javascript/jstree/dist/themes/default/32px.png',
            'include/javascript/jstree/dist/themes/default/40px.png',
            'include/javascript/jstree/dist/themes/default/style.css',
            'include/javascript/jstree/dist/themes/default/style.min.css',
            'include/javascript/jstree/dist/themes/default/throbber.gif',
            'include/javascript/jstree/gruntfile.js',
            'include/javascript/jstree/jstree.jquery.json',
            'include/javascript/jstree/package.json',
            'include/javascript/jstree/src/intro.js',
            'include/javascript/jstree/src/jstree.changed.js',
            'include/javascript/jstree/src/jstree.checkbox.js',
            'include/javascript/jstree/src/jstree.conditionalselect.js',
            'include/javascript/jstree/src/jstree.contextmenu.js',
            'include/javascript/jstree/src/jstree.dnd.js',
            'include/javascript/jstree/src/jstree.js',
            'include/javascript/jstree/src/jstree.massload.js',
            'include/javascript/jstree/src/jstree.search.js',
            'include/javascript/jstree/src/jstree.sort.js',
            'include/javascript/jstree/src/jstree.state.js',
            'include/javascript/jstree/src/jstree.types.js',
            'include/javascript/jstree/src/jstree.unique.js',
            'include/javascript/jstree/src/jstree.wholerow.js',
            'include/javascript/jstree/src/misc.js',
            'include/javascript/jstree/src/outro.js',
            'include/javascript/jstree/src/sample.js',
            'include/javascript/jstree/src/themes/base.less',
            'include/javascript/jstree/src/themes/default-dark/32px.png',
            'include/javascript/jstree/src/themes/default-dark/40px.png',
            'include/javascript/jstree/src/themes/default-dark/style.css',
            'include/javascript/jstree/src/themes/default-dark/style.less',
            'include/javascript/jstree/src/themes/default-dark/throbber.gif',
            'include/javascript/jstree/src/themes/default/32px.png',
            'include/javascript/jstree/src/themes/default/40px.png',
            'include/javascript/jstree/src/themes/default/style.css',
            'include/javascript/jstree/src/themes/default/style.less',
            'include/javascript/jstree/src/themes/default/throbber.gif',
            'include/javascript/jstree/src/themes/main.less',
            'include/javascript/jstree/src/themes/mixins.less',
            'include/javascript/jstree/src/themes/responsive.less',
            'include/javascript/jstree/src/vakata-jstree.js',
            'include/javascript/jstree/test/unit/index.html',
            'include/javascript/jstree/test/unit/libs/qunit.css',
            'include/javascript/jstree/test/unit/libs/qunit.js',
            'include/javascript/jstree/test/unit/test.js',
            'include/javascript/jstree/test/visual/desktop/index.html',
            'include/javascript/jstree/test/visual/mobile/index.html',
            'include/javascript/jstree/test/visual/screenshots/desktop/.png',
            'include/javascript/jstree/test/visual/screenshots/desktop/desktop.png',
            'include/javascript/jstree/test/visual/screenshots/desktop/home.png',
            'include/javascript/jstree/test/visual/screenshots/mobile/.png',
            'include/javascript/jstree/test/visual/screenshots/mobile/home.png',
            'include/javascript/jstree/test/visual/screenshots/mobile/mobile.png',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/.gitignore',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/.jshintrc',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/README.md',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/bower.json',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/composer.json',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/contributing.md',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/gulpfile.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/imagesloaded.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/imagesloaded.pkgd.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/imagesloaded.pkgd.min.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/package.json',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/sandbox/background/css/background.css',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/sandbox/background/index.html',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/sandbox/progress/index.html',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/sandbox/progress/progress.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/css/tests.css',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/img/blue-shell.jpg',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/img/bowser-jr.jpg',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/img/thunder-cloud.jpg',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/index.html',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/append.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/background.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/basics.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/data-uri.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/jquery-fail.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/jquery-success.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/local-files.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/no-images.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/non-element.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/selector-string.js',
            'include/javascript/mozaik/vendor/gymadarasz/imagesloaded/test/unit/single-element.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/.npmignore',
            'include/javascript/mozaik/vendor/tinymce/tinymce/bower.json',
            'include/javascript/mozaik/vendor/tinymce/tinymce/changelog.txt',
            'include/javascript/mozaik/vendor/tinymce/tinymce/composer.json',
            'include/javascript/mozaik/vendor/tinymce/tinymce/jquery.tinymce.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/license.txt',
            'include/javascript/mozaik/vendor/tinymce/tinymce/package.json',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/advlist/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/advlist/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/anchor/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/anchor/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/autolink/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/autolink/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/autoresize/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/autoresize/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/autosave/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/autosave/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/bbcode/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/bbcode/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/charmap/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/charmap/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/code/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/code/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/codesample/css/prism.css',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/codesample/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/codesample/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/colorpicker/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/colorpicker/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/contextmenu/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/contextmenu/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/directionality/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/directionality/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-cool.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-cry.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-embarassed.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-foot-in-mouth.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-frown.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-innocent.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-kiss.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-laughing.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-money-mouth.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-sealed.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-smile.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-surprised.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-tongue-out.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-undecided.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-wink.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/img/smiley-yell.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/emoticons/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/fullpage/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/fullpage/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/fullscreen/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/fullscreen/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/hr/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/hr/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/image/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/image/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/imagetools/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/imagetools/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/importcss/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/importcss/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/insertdatetime/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/insertdatetime/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/layer/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/layer/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/legacyoutput/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/legacyoutput/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/link/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/link/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/lists/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/lists/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/media/moxieplayer.swf',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/media/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/media/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/nonbreaking/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/nonbreaking/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/noneditable/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/noneditable/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/pagebreak/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/pagebreak/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/paste/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/paste/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/preview/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/preview/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/print/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/print/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/save/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/save/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/searchreplace/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/searchreplace/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/spellchecker/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/spellchecker/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/tabfocus/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/tabfocus/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/table/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/table/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/template/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/template/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/textcolor/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/textcolor/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/textpattern/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/textpattern/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/visualblocks/css/visualblocks.css',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/visualblocks/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/visualblocks/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/visualchars/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/visualchars/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/wordcount/plugin.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/plugins/wordcount/plugin.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/readme.md',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/content.inline.min.css',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/content.min.css',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce-small.eot',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce-small.svg',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce-small.ttf',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce-small.woff',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce.eot',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce.svg',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce.ttf',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/fonts/tinymce.woff',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/img/anchor.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/img/loader.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/img/object.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/img/trans.gif',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/skin.ie7.min.css',
            'include/javascript/mozaik/vendor/tinymce/tinymce/skins/lightgray/skin.min.css',
            'include/javascript/mozaik/vendor/tinymce/tinymce/themes/modern/theme.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/themes/modern/theme.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/tinymce.jquery.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/tinymce.jquery.min.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/tinymce.js',
            'include/javascript/mozaik/vendor/tinymce/tinymce/tinymce.min.js',
            'include/javascript/yui/index.html',
            'include/javascript/yui3/README',
            'include/javascript/yui3/assets/bg_hd.gif',
            'include/javascript/yui3/assets/bullet-box6x6.gif',
            'include/javascript/yui3/assets/bullet4x4.png',
            'include/javascript/yui3/assets/cheatsheet-shadow.jpg',
            'include/javascript/yui3/assets/cheatsheet-thumbnail.png',
            'include/javascript/yui3/assets/download-arrow.png',
            'include/javascript/yui3/assets/dpSyntaxHighlighter.css',
            'include/javascript/yui3/assets/dpSyntaxHighlighter.js',
            'include/javascript/yui3/assets/example-hd-bg.gif',
            'include/javascript/yui3/assets/gradient-ex-box.png',
            'include/javascript/yui3/assets/gradient-mod.png',
            'include/javascript/yui3/assets/gradient-promo.png',
            'include/javascript/yui3/assets/logo.gif',
            'include/javascript/yui3/assets/syntax.js',
            'include/javascript/yui3/assets/title_h_bg.gif',
            'include/javascript/yui3/assets/yui-candy.jpg',
            'include/javascript/yui3/assets/yui.css',
            'include/javascript/yui3/assets/yui.gif',
            'include/javascript/yui3/assets/yuiDistribution.css',
            'include/javascript/yui3/build/anim/anim-base-min.js',
            'include/javascript/yui3/build/anim/anim-base.js',
            'include/javascript/yui3/build/anim/anim-color-min.js',
            'include/javascript/yui3/build/anim/anim-color.js',
            'include/javascript/yui3/build/anim/anim-curve-min.js',
            'include/javascript/yui3/build/anim/anim-curve.js',
            'include/javascript/yui3/build/anim/anim-easing-min.js',
            'include/javascript/yui3/build/anim/anim-easing.js',
            'include/javascript/yui3/build/anim/anim-min.js',
            'include/javascript/yui3/build/anim/anim-node-plugin-min.js',
            'include/javascript/yui3/build/anim/anim-node-plugin.js',
            'include/javascript/yui3/build/anim/anim-scroll-min.js',
            'include/javascript/yui3/build/anim/anim-scroll.js',
            'include/javascript/yui3/build/anim/anim-xy-min.js',
            'include/javascript/yui3/build/anim/anim-xy.js',
            'include/javascript/yui3/build/anim/anim.js',
            'include/javascript/yui3/build/arraysort/arraysort-min.js',
            'include/javascript/yui3/build/arraysort/arraysort.js',
            'include/javascript/yui3/build/assets/skins/sam/arrows.png',
            'include/javascript/yui3/build/assets/skins/sam/autocomplete-list.css',
            'include/javascript/yui3/build/assets/skins/sam/autocomplete.css',
            'include/javascript/yui3/build/assets/skins/sam/bg.png',
            'include/javascript/yui3/build/assets/skins/sam/console-filters.css',
            'include/javascript/yui3/build/assets/skins/sam/console.css',
            'include/javascript/yui3/build/assets/skins/sam/datatable-base.css',
            'include/javascript/yui3/build/assets/skins/sam/datatable.css',
            'include/javascript/yui3/build/assets/skins/sam/dial.css',
            'include/javascript/yui3/build/assets/skins/sam/dt-arrow-dn.png',
            'include/javascript/yui3/build/assets/skins/sam/dt-arrow-up.png',
            'include/javascript/yui3/build/assets/skins/sam/horizontal-menu-submenu-indicator.png',
            'include/javascript/yui3/build/assets/skins/sam/horizontal-menu-submenu-toggle.png',
            'include/javascript/yui3/build/assets/skins/sam/node-flick.css',
            'include/javascript/yui3/build/assets/skins/sam/node-menunav.css',
            'include/javascript/yui3/build/assets/skins/sam/overlay.css',
            'include/javascript/yui3/build/assets/skins/sam/rail-classic-x.png',
            'include/javascript/yui3/build/assets/skins/sam/rail-classic-y.png',
            'include/javascript/yui3/build/assets/skins/sam/rail-x-lines.png',
            'include/javascript/yui3/build/assets/skins/sam/rail-x.png',
            'include/javascript/yui3/build/assets/skins/sam/rail-y-lines.png',
            'include/javascript/yui3/build/assets/skins/sam/rail-y.png',
            'include/javascript/yui3/build/assets/skins/sam/resize-base.css',
            'include/javascript/yui3/build/assets/skins/sam/resize.css',
            'include/javascript/yui3/build/assets/skins/sam/scrollview-base.css',
            'include/javascript/yui3/build/assets/skins/sam/scrollview-paginator.css',
            'include/javascript/yui3/build/assets/skins/sam/scrollview-scrollbars.css',
            'include/javascript/yui3/build/assets/skins/sam/skin.css',
            'include/javascript/yui3/build/assets/skins/sam/slider-base.css',
            'include/javascript/yui3/build/assets/skins/sam/slider.css',
            'include/javascript/yui3/build/assets/skins/sam/sprite.png',
            'include/javascript/yui3/build/assets/skins/sam/tabview.css',
            'include/javascript/yui3/build/assets/skins/sam/test.css',
            'include/javascript/yui3/build/assets/skins/sam/thumb-classic-x.png',
            'include/javascript/yui3/build/assets/skins/sam/thumb-classic-y.png',
            'include/javascript/yui3/build/assets/skins/sam/thumb-x.png',
            'include/javascript/yui3/build/assets/skins/sam/thumb-y.png',
            'include/javascript/yui3/build/assets/skins/sam/tmp.txt',
            'include/javascript/yui3/build/assets/skins/sam/vertical-menu-submenu-indicator.png',
            'include/javascript/yui3/build/assets/skins/sam/warn_error.png',
            'include/javascript/yui3/build/assets/skins/sam/widget-base.css',
            'include/javascript/yui3/build/assets/skins/sam/widget-stack.css',
            'include/javascript/yui3/build/assets/skins/sam/widget.css',
            'include/javascript/yui3/build/async-queue/async-queue-min.js',
            'include/javascript/yui3/build/async-queue/async-queue.js',
            'include/javascript/yui3/build/attribute/attribute-base-min.js',
            'include/javascript/yui3/build/attribute/attribute-base.js',
            'include/javascript/yui3/build/attribute/attribute-complex-min.js',
            'include/javascript/yui3/build/attribute/attribute-complex.js',
            'include/javascript/yui3/build/attribute/attribute-min.js',
            'include/javascript/yui3/build/attribute/attribute.js',
            'include/javascript/yui3/build/autocomplete/assets/autocomplete-list-core.css',
            'include/javascript/yui3/build/autocomplete/assets/skins/sam/autocomplete-list-skin.css',
            'include/javascript/yui3/build/autocomplete/assets/skins/sam/autocomplete-list.css',
            'include/javascript/yui3/build/autocomplete/assets/skins/sam/autocomplete.css',
            'include/javascript/yui3/build/autocomplete/autocomplete-base-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-base.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-filters-accentfold-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-filters-accentfold.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-filters-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-filters.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-highlighters-accentfold-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-highlighters-accentfold.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-highlighters-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-highlighters.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-list-keys-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-list-keys.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-list-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-list.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-plugin-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-plugin.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-sources-min.js',
            'include/javascript/yui3/build/autocomplete/autocomplete-sources.js',
            'include/javascript/yui3/build/autocomplete/autocomplete.js',
            'include/javascript/yui3/build/autocomplete/lang/autocomplete-list.js',
            'include/javascript/yui3/build/autocomplete/lang/autocomplete-list_en.js',
            'include/javascript/yui3/build/autocomplete/lang/autocomplete.js',
            'include/javascript/yui3/build/autocomplete/lang/autocomplete_en.js',
            'include/javascript/yui3/build/base/base-base-min.js',
            'include/javascript/yui3/build/base/base-base.js',
            'include/javascript/yui3/build/base/base-build-min.js',
            'include/javascript/yui3/build/base/base-build.js',
            'include/javascript/yui3/build/base/base-min.js',
            'include/javascript/yui3/build/base/base-pluginhost-min.js',
            'include/javascript/yui3/build/base/base-pluginhost.js',
            'include/javascript/yui3/build/base/base.js',
            'include/javascript/yui3/build/cache/cache-base-min.js',
            'include/javascript/yui3/build/cache/cache-base.js',
            'include/javascript/yui3/build/cache/cache-min.js',
            'include/javascript/yui3/build/cache/cache-offline-min.js',
            'include/javascript/yui3/build/cache/cache-offline.js',
            'include/javascript/yui3/build/cache/cache-plugin-min.js',
            'include/javascript/yui3/build/cache/cache-plugin.js',
            'include/javascript/yui3/build/cache/cache.js',
            'include/javascript/yui3/build/charts/charts-min.js',
            'include/javascript/yui3/build/charts/charts.js',
            'include/javascript/yui3/build/classnamemanager/classnamemanager-min.js',
            'include/javascript/yui3/build/classnamemanager/classnamemanager.js',
            'include/javascript/yui3/build/collection/array-extras-min.js',
            'include/javascript/yui3/build/collection/array-extras.js',
            'include/javascript/yui3/build/collection/array-invoke-min.js',
            'include/javascript/yui3/build/collection/array-invoke.js',
            'include/javascript/yui3/build/collection/arraylist-add-min.js',
            'include/javascript/yui3/build/collection/arraylist-add.js',
            'include/javascript/yui3/build/collection/arraylist-filter-min.js',
            'include/javascript/yui3/build/collection/arraylist-filter.js',
            'include/javascript/yui3/build/collection/arraylist-min.js',
            'include/javascript/yui3/build/collection/arraylist.js',
            'include/javascript/yui3/build/collection/collection-min.js',
            'include/javascript/yui3/build/collection/collection.js',
            'include/javascript/yui3/build/compat/compat-min.js',
            'include/javascript/yui3/build/compat/compat.js',
            'include/javascript/yui3/build/console/assets/console-core.css',
            'include/javascript/yui3/build/console/assets/console-filters-core.css',
            'include/javascript/yui3/build/console/assets/skins/sam/bg.png',
            'include/javascript/yui3/build/console/assets/skins/sam/console-filters-skin.css',
            'include/javascript/yui3/build/console/assets/skins/sam/console-filters.css',
            'include/javascript/yui3/build/console/assets/skins/sam/console-skin.css',
            'include/javascript/yui3/build/console/assets/skins/sam/console.css',
            'include/javascript/yui3/build/console/assets/skins/sam/warn_error.png',
            'include/javascript/yui3/build/console/assets/warn_error.png',
            'include/javascript/yui3/build/console/console-filters-min.js',
            'include/javascript/yui3/build/console/console-filters.js',
            'include/javascript/yui3/build/console/console-min.js',
            'include/javascript/yui3/build/console/console.js',
            'include/javascript/yui3/build/console/lang/console.js',
            'include/javascript/yui3/build/console/lang/console_en.js',
            'include/javascript/yui3/build/console/lang/console_es.js',
            'include/javascript/yui3/build/cookie/cookie-min.js',
            'include/javascript/yui3/build/cookie/cookie.js',
            'include/javascript/yui3/build/cssbase/base-context-min.css',
            'include/javascript/yui3/build/cssbase/base-context.css',
            'include/javascript/yui3/build/cssbase/base-min.css',
            'include/javascript/yui3/build/cssbase/base.css',
            'include/javascript/yui3/build/cssfonts/fonts-context-min.css',
            'include/javascript/yui3/build/cssfonts/fonts-context.css',
            'include/javascript/yui3/build/cssfonts/fonts-min.css',
            'include/javascript/yui3/build/cssfonts/fonts.css',
            'include/javascript/yui3/build/cssgrids-deprecated/grids-context-min.css',
            'include/javascript/yui3/build/cssgrids-deprecated/grids-context.css',
            'include/javascript/yui3/build/cssgrids-deprecated/grids-min.css',
            'include/javascript/yui3/build/cssgrids-deprecated/grids.css',
            'include/javascript/yui3/build/cssgrids/grids-min.css',
            'include/javascript/yui3/build/cssgrids/grids.css',
            'include/javascript/yui3/build/cssreset/reset-context-min.css',
            'include/javascript/yui3/build/cssreset/reset-context.css',
            'include/javascript/yui3/build/cssreset/reset-min.css',
            'include/javascript/yui3/build/cssreset/reset.css',
            'include/javascript/yui3/build/dataschema/dataschema-array-min.js',
            'include/javascript/yui3/build/dataschema/dataschema-array.js',
            'include/javascript/yui3/build/dataschema/dataschema-base-min.js',
            'include/javascript/yui3/build/dataschema/dataschema-base.js',
            'include/javascript/yui3/build/dataschema/dataschema-json-min.js',
            'include/javascript/yui3/build/dataschema/dataschema-json.js',
            'include/javascript/yui3/build/dataschema/dataschema-min.js',
            'include/javascript/yui3/build/dataschema/dataschema-text-min.js',
            'include/javascript/yui3/build/dataschema/dataschema-text.js',
            'include/javascript/yui3/build/dataschema/dataschema-xml-min.js',
            'include/javascript/yui3/build/dataschema/dataschema-xml.js',
            'include/javascript/yui3/build/dataschema/dataschema.js',
            'include/javascript/yui3/build/datasource/datasource-arrayschema-min.js',
            'include/javascript/yui3/build/datasource/datasource-arrayschema.js',
            'include/javascript/yui3/build/datasource/datasource-cache-min.js',
            'include/javascript/yui3/build/datasource/datasource-cache.js',
            'include/javascript/yui3/build/datasource/datasource-function-min.js',
            'include/javascript/yui3/build/datasource/datasource-function.js',
            'include/javascript/yui3/build/datasource/datasource-get-min.js',
            'include/javascript/yui3/build/datasource/datasource-get.js',
            'include/javascript/yui3/build/datasource/datasource-io-min.js',
            'include/javascript/yui3/build/datasource/datasource-io.js',
            'include/javascript/yui3/build/datasource/datasource-jsonschema-min.js',
            'include/javascript/yui3/build/datasource/datasource-jsonschema.js',
            'include/javascript/yui3/build/datasource/datasource-local-min.js',
            'include/javascript/yui3/build/datasource/datasource-local.js',
            'include/javascript/yui3/build/datasource/datasource-min.js',
            'include/javascript/yui3/build/datasource/datasource-polling-min.js',
            'include/javascript/yui3/build/datasource/datasource-polling.js',
            'include/javascript/yui3/build/datasource/datasource-textschema-min.js',
            'include/javascript/yui3/build/datasource/datasource-textschema.js',
            'include/javascript/yui3/build/datasource/datasource-xmlschema-min.js',
            'include/javascript/yui3/build/datasource/datasource-xmlschema.js',
            'include/javascript/yui3/build/datasource/datasource.js',
            'include/javascript/yui3/build/datatable/assets/datatable-base-core.css',
            'include/javascript/yui3/build/datatable/assets/datatable-core.css',
            'include/javascript/yui3/build/datatable/assets/skins/sam/datatable-base-skin.css',
            'include/javascript/yui3/build/datatable/assets/skins/sam/datatable-base.css',
            'include/javascript/yui3/build/datatable/assets/skins/sam/datatable.css',
            'include/javascript/yui3/build/datatable/assets/skins/sam/dt-arrow-dn.png',
            'include/javascript/yui3/build/datatable/assets/skins/sam/dt-arrow-up.png',
            'include/javascript/yui3/build/datatable/assets/skins/sam/tmp.txt',
            'include/javascript/yui3/build/datatable/datatable-base-min.js',
            'include/javascript/yui3/build/datatable/datatable-base.js',
            'include/javascript/yui3/build/datatable/datatable-datasource-min.js',
            'include/javascript/yui3/build/datatable/datatable-datasource.js',
            'include/javascript/yui3/build/datatable/datatable-min.js',
            'include/javascript/yui3/build/datatable/datatable-scroll-min.js',
            'include/javascript/yui3/build/datatable/datatable-scroll.js',
            'include/javascript/yui3/build/datatable/datatable-sort-min.js',
            'include/javascript/yui3/build/datatable/datatable-sort.js',
            'include/javascript/yui3/build/datatable/datatable.js',
            'include/javascript/yui3/build/datatable/lang/datatable-base.js',
            'include/javascript/yui3/build/datatable/lang/datatable-base_en.js',
            'include/javascript/yui3/build/datatable/lang/datatable-sort.js',
            'include/javascript/yui3/build/datatable/lang/datatable-sort_en.js',
            'include/javascript/yui3/build/datatable/lang/datatable.js',
            'include/javascript/yui3/build/datatable/lang/datatable_en.js',
            'include/javascript/yui3/build/datatype/datatype-date-format-min.js',
            'include/javascript/yui3/build/datatype/datatype-date-format.js',
            'include/javascript/yui3/build/datatype/datatype-date-min.js',
            'include/javascript/yui3/build/datatype/datatype-date-parse-min.js',
            'include/javascript/yui3/build/datatype/datatype-date-parse.js',
            'include/javascript/yui3/build/datatype/datatype-date.js',
            'include/javascript/yui3/build/datatype/datatype-min.js',
            'include/javascript/yui3/build/datatype/datatype-number-format-min.js',
            'include/javascript/yui3/build/datatype/datatype-number-format.js',
            'include/javascript/yui3/build/datatype/datatype-number-min.js',
            'include/javascript/yui3/build/datatype/datatype-number-parse-min.js',
            'include/javascript/yui3/build/datatype/datatype-number-parse.js',
            'include/javascript/yui3/build/datatype/datatype-number.js',
            'include/javascript/yui3/build/datatype/datatype-xml-format-min.js',
            'include/javascript/yui3/build/datatype/datatype-xml-format.js',
            'include/javascript/yui3/build/datatype/datatype-xml-min.js',
            'include/javascript/yui3/build/datatype/datatype-xml-parse-min.js',
            'include/javascript/yui3/build/datatype/datatype-xml-parse.js',
            'include/javascript/yui3/build/datatype/datatype-xml.js',
            'include/javascript/yui3/build/datatype/datatype.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ar-JO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ar.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ca-ES.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ca.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_da-DK.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_da.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_de-AT.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_de-DE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_de.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_el-GR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_el.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-AU.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-CA.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-GB.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-IE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-IN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-JO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-MY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-NZ.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-PH.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-SG.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en-US.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_en.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-AR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-BO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-CL.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-CO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-EC.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-ES.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-MX.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-PE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-PY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-US.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-UY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es-VE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_es.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_fi-FI.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_fi.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_fr-BE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_fr-CA.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_fr-FR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_fr.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_hi-IN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_hi.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_id-ID.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_id.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_it-IT.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_it.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ja-JP.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ja.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ko-KR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ko.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ms-MY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ms.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_nb-NO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_nb.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_nl-BE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_nl-NL.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_nl.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_pl-PL.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_pl.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_pt-BR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_pt.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ro-RO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ro.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ru-RU.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_ru.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_sv-SE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_sv.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_th-TH.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_th.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_tr-TR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_tr.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_vi-VN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_vi.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hans-CN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hans.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hant-HK.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hant-TW.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hant.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ar-JO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ar.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ca-ES.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ca.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_da-DK.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_da.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_de-AT.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_de-DE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_de.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_el-GR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_el.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-AU.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-CA.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-GB.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-IE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-IN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-JO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-MY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-NZ.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-PH.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-SG.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en-US.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_en.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-AR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-BO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-CL.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-CO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-EC.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-ES.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-MX.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-PE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-PY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-US.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-UY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es-VE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_es.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_fi-FI.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_fi.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_fr-BE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_fr-CA.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_fr-FR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_fr.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_hi-IN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_hi.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_id-ID.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_id.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_it-IT.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_it.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ja-JP.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ja.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ko-KR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ko.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ms-MY.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ms.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_nb-NO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_nb.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_nl-BE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_nl-NL.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_nl.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_pl-PL.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_pl.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_pt-BR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_pt.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ro-RO.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ro.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ru-RU.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_ru.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_sv-SE.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_sv.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_th-TH.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_th.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_tr-TR.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_tr.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_vi-VN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_vi.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hans-CN.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hans.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hant-HK.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hant-TW.js',
            'include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hant.js',
            'include/javascript/yui3/build/datatype/lang/datatype.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ar-JO.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ar.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ca-ES.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ca.js',
            'include/javascript/yui3/build/datatype/lang/datatype_da-DK.js',
            'include/javascript/yui3/build/datatype/lang/datatype_da.js',
            'include/javascript/yui3/build/datatype/lang/datatype_de-AT.js',
            'include/javascript/yui3/build/datatype/lang/datatype_de-DE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_de.js',
            'include/javascript/yui3/build/datatype/lang/datatype_el-GR.js',
            'include/javascript/yui3/build/datatype/lang/datatype_el.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-AU.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-CA.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-GB.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-IE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-IN.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-JO.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-MY.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-NZ.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-PH.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-SG.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en-US.js',
            'include/javascript/yui3/build/datatype/lang/datatype_en.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-AR.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-BO.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-CL.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-CO.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-EC.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-ES.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-MX.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-PE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-PY.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-US.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-UY.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es-VE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_es.js',
            'include/javascript/yui3/build/datatype/lang/datatype_fi-FI.js',
            'include/javascript/yui3/build/datatype/lang/datatype_fi.js',
            'include/javascript/yui3/build/datatype/lang/datatype_fr-BE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_fr-CA.js',
            'include/javascript/yui3/build/datatype/lang/datatype_fr-FR.js',
            'include/javascript/yui3/build/datatype/lang/datatype_fr.js',
            'include/javascript/yui3/build/datatype/lang/datatype_hi-IN.js',
            'include/javascript/yui3/build/datatype/lang/datatype_hi.js',
            'include/javascript/yui3/build/datatype/lang/datatype_id-ID.js',
            'include/javascript/yui3/build/datatype/lang/datatype_id.js',
            'include/javascript/yui3/build/datatype/lang/datatype_it-IT.js',
            'include/javascript/yui3/build/datatype/lang/datatype_it.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ja-JP.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ja.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ko-KR.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ko.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ms-MY.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ms.js',
            'include/javascript/yui3/build/datatype/lang/datatype_nb-NO.js',
            'include/javascript/yui3/build/datatype/lang/datatype_nb.js',
            'include/javascript/yui3/build/datatype/lang/datatype_nl-BE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_nl-NL.js',
            'include/javascript/yui3/build/datatype/lang/datatype_nl.js',
            'include/javascript/yui3/build/datatype/lang/datatype_pl-PL.js',
            'include/javascript/yui3/build/datatype/lang/datatype_pl.js',
            'include/javascript/yui3/build/datatype/lang/datatype_pt-BR.js',
            'include/javascript/yui3/build/datatype/lang/datatype_pt.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ro-RO.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ro.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ru-RU.js',
            'include/javascript/yui3/build/datatype/lang/datatype_ru.js',
            'include/javascript/yui3/build/datatype/lang/datatype_sv-SE.js',
            'include/javascript/yui3/build/datatype/lang/datatype_sv.js',
            'include/javascript/yui3/build/datatype/lang/datatype_th-TH.js',
            'include/javascript/yui3/build/datatype/lang/datatype_th.js',
            'include/javascript/yui3/build/datatype/lang/datatype_tr-TR.js',
            'include/javascript/yui3/build/datatype/lang/datatype_tr.js',
            'include/javascript/yui3/build/datatype/lang/datatype_vi-VN.js',
            'include/javascript/yui3/build/datatype/lang/datatype_vi.js',
            'include/javascript/yui3/build/datatype/lang/datatype_zh-Hans-CN.js',
            'include/javascript/yui3/build/datatype/lang/datatype_zh-Hans.js',
            'include/javascript/yui3/build/datatype/lang/datatype_zh-Hant-HK.js',
            'include/javascript/yui3/build/datatype/lang/datatype_zh-Hant-TW.js',
            'include/javascript/yui3/build/datatype/lang/datatype_zh-Hant.js',
            'include/javascript/yui3/build/dd/dd-constrain-min.js',
            'include/javascript/yui3/build/dd/dd-constrain.js',
            'include/javascript/yui3/build/dd/dd-ddm-base-min.js',
            'include/javascript/yui3/build/dd/dd-ddm-base.js',
            'include/javascript/yui3/build/dd/dd-ddm-drop-min.js',
            'include/javascript/yui3/build/dd/dd-ddm-drop.js',
            'include/javascript/yui3/build/dd/dd-ddm-min.js',
            'include/javascript/yui3/build/dd/dd-ddm.js',
            'include/javascript/yui3/build/dd/dd-delegate-min.js',
            'include/javascript/yui3/build/dd/dd-delegate.js',
            'include/javascript/yui3/build/dd/dd-drag-min.js',
            'include/javascript/yui3/build/dd/dd-drag.js',
            'include/javascript/yui3/build/dd/dd-drop-min.js',
            'include/javascript/yui3/build/dd/dd-drop-plugin-min.js',
            'include/javascript/yui3/build/dd/dd-drop-plugin.js',
            'include/javascript/yui3/build/dd/dd-drop.js',
            'include/javascript/yui3/build/dd/dd-gestures-min.js',
            'include/javascript/yui3/build/dd/dd-gestures.js',
            'include/javascript/yui3/build/dd/dd-min.js',
            'include/javascript/yui3/build/dd/dd-plugin-min.js',
            'include/javascript/yui3/build/dd/dd-plugin.js',
            'include/javascript/yui3/build/dd/dd-proxy-min.js',
            'include/javascript/yui3/build/dd/dd-proxy.js',
            'include/javascript/yui3/build/dd/dd-scroll-min.js',
            'include/javascript/yui3/build/dd/dd-scroll.js',
            'include/javascript/yui3/build/dd/dd.js',
            'include/javascript/yui3/build/dial/assets/dial-core.css',
            'include/javascript/yui3/build/dial/assets/skins/sam/dial-skin.css',
            'include/javascript/yui3/build/dial/assets/skins/sam/dial.css',
            'include/javascript/yui3/build/dial/dial-min.js',
            'include/javascript/yui3/build/dial/dial.js',
            'include/javascript/yui3/build/dial/lang/dial.js',
            'include/javascript/yui3/build/dial/lang/dial_en.js',
            'include/javascript/yui3/build/dial/lang/dial_es.js',
            'include/javascript/yui3/build/dom/dom-base-min.js',
            'include/javascript/yui3/build/dom/dom-base.js',
            'include/javascript/yui3/build/dom/dom-deprecated-min.js',
            'include/javascript/yui3/build/dom/dom-deprecated.js',
            'include/javascript/yui3/build/dom/dom-min.js',
            'include/javascript/yui3/build/dom/dom-screen-min.js',
            'include/javascript/yui3/build/dom/dom-screen.js',
            'include/javascript/yui3/build/dom/dom-style-ie-min.js',
            'include/javascript/yui3/build/dom/dom-style-ie.js',
            'include/javascript/yui3/build/dom/dom-style-min.js',
            'include/javascript/yui3/build/dom/dom-style.js',
            'include/javascript/yui3/build/dom/dom.js',
            'include/javascript/yui3/build/dom/selector-css2-min.js',
            'include/javascript/yui3/build/dom/selector-css2.js',
            'include/javascript/yui3/build/dom/selector-css3-min.js',
            'include/javascript/yui3/build/dom/selector-css3.js',
            'include/javascript/yui3/build/dom/selector-min.js',
            'include/javascript/yui3/build/dom/selector-native-min.js',
            'include/javascript/yui3/build/dom/selector-native.js',
            'include/javascript/yui3/build/dom/selector.js',
            'include/javascript/yui3/build/dump/dump-min.js',
            'include/javascript/yui3/build/dump/dump.js',
            'include/javascript/yui3/build/editor/createlink-base-min.js',
            'include/javascript/yui3/build/editor/createlink-base.js',
            'include/javascript/yui3/build/editor/editor-base-min.js',
            'include/javascript/yui3/build/editor/editor-base.js',
            'include/javascript/yui3/build/editor/editor-bidi-min.js',
            'include/javascript/yui3/build/editor/editor-bidi.js',
            'include/javascript/yui3/build/editor/editor-br-min.js',
            'include/javascript/yui3/build/editor/editor-br.js',
            'include/javascript/yui3/build/editor/editor-lists-min.js',
            'include/javascript/yui3/build/editor/editor-lists.js',
            'include/javascript/yui3/build/editor/editor-min.js',
            'include/javascript/yui3/build/editor/editor-para-min.js',
            'include/javascript/yui3/build/editor/editor-para.js',
            'include/javascript/yui3/build/editor/editor-tab-min.js',
            'include/javascript/yui3/build/editor/editor-tab.js',
            'include/javascript/yui3/build/editor/editor.js',
            'include/javascript/yui3/build/editor/exec-command-min.js',
            'include/javascript/yui3/build/editor/exec-command.js',
            'include/javascript/yui3/build/editor/frame-min.js',
            'include/javascript/yui3/build/editor/frame.js',
            'include/javascript/yui3/build/editor/selection-min.js',
            'include/javascript/yui3/build/editor/selection.js',
            'include/javascript/yui3/build/escape/escape-min.js',
            'include/javascript/yui3/build/escape/escape.js',
            'include/javascript/yui3/build/event-custom/event-custom-base-min.js',
            'include/javascript/yui3/build/event-custom/event-custom-base.js',
            'include/javascript/yui3/build/event-custom/event-custom-complex-min.js',
            'include/javascript/yui3/build/event-custom/event-custom-complex.js',
            'include/javascript/yui3/build/event-custom/event-custom-min.js',
            'include/javascript/yui3/build/event-custom/event-custom.js',
            'include/javascript/yui3/build/event-gestures/event-flick-min.js',
            'include/javascript/yui3/build/event-gestures/event-flick.js',
            'include/javascript/yui3/build/event-gestures/event-gestures-min.js',
            'include/javascript/yui3/build/event-gestures/event-gestures.js',
            'include/javascript/yui3/build/event-gestures/event-move-min.js',
            'include/javascript/yui3/build/event-gestures/event-move.js',
            'include/javascript/yui3/build/event-simulate/event-simulate-min.js',
            'include/javascript/yui3/build/event-simulate/event-simulate.js',
            'include/javascript/yui3/build/event-valuechange/event-valuechange-min.js',
            'include/javascript/yui3/build/event-valuechange/event-valuechange.js',
            'include/javascript/yui3/build/event/event-base-ie-min.js',
            'include/javascript/yui3/build/event/event-base-ie.js',
            'include/javascript/yui3/build/event/event-base-min.js',
            'include/javascript/yui3/build/event/event-base.js',
            'include/javascript/yui3/build/event/event-delegate-min.js',
            'include/javascript/yui3/build/event/event-delegate.js',
            'include/javascript/yui3/build/event/event-focus-min.js',
            'include/javascript/yui3/build/event/event-focus.js',
            'include/javascript/yui3/build/event/event-hover-min.js',
            'include/javascript/yui3/build/event/event-hover.js',
            'include/javascript/yui3/build/event/event-key-min.js',
            'include/javascript/yui3/build/event/event-key.js',
            'include/javascript/yui3/build/event/event-min.js',
            'include/javascript/yui3/build/event/event-mouseenter-min.js',
            'include/javascript/yui3/build/event/event-mouseenter.js',
            'include/javascript/yui3/build/event/event-mousewheel-min.js',
            'include/javascript/yui3/build/event/event-mousewheel.js',
            'include/javascript/yui3/build/event/event-resize-min.js',
            'include/javascript/yui3/build/event/event-resize.js',
            'include/javascript/yui3/build/event/event-synthetic-min.js',
            'include/javascript/yui3/build/event/event-synthetic.js',
            'include/javascript/yui3/build/event/event-touch-min.js',
            'include/javascript/yui3/build/event/event-touch.js',
            'include/javascript/yui3/build/event/event.js',
            'include/javascript/yui3/build/highlight/highlight-accentfold-min.js',
            'include/javascript/yui3/build/highlight/highlight-accentfold.js',
            'include/javascript/yui3/build/highlight/highlight-base-min.js',
            'include/javascript/yui3/build/highlight/highlight-base.js',
            'include/javascript/yui3/build/highlight/highlight-min.js',
            'include/javascript/yui3/build/highlight/highlight.js',
            'include/javascript/yui3/build/history-deprecated/history-deprecated-min.js',
            'include/javascript/yui3/build/history-deprecated/history-deprecated.js',
            'include/javascript/yui3/build/history/history-base-min.js',
            'include/javascript/yui3/build/history/history-base.js',
            'include/javascript/yui3/build/history/history-hash-ie-min.js',
            'include/javascript/yui3/build/history/history-hash-ie.js',
            'include/javascript/yui3/build/history/history-hash-min.js',
            'include/javascript/yui3/build/history/history-hash.js',
            'include/javascript/yui3/build/history/history-html5-min.js',
            'include/javascript/yui3/build/history/history-html5.js',
            'include/javascript/yui3/build/history/history-min.js',
            'include/javascript/yui3/build/history/history.js',
            'include/javascript/yui3/build/imageloader/imageloader-min.js',
            'include/javascript/yui3/build/imageloader/imageloader.js',
            'include/javascript/yui3/build/intl/intl-min.js',
            'include/javascript/yui3/build/intl/intl.js',
            'include/javascript/yui3/build/io/io-base-min.js',
            'include/javascript/yui3/build/io/io-base.js',
            'include/javascript/yui3/build/io/io-form-min.js',
            'include/javascript/yui3/build/io/io-form.js',
            'include/javascript/yui3/build/io/io-min.js',
            'include/javascript/yui3/build/io/io-queue-min.js',
            'include/javascript/yui3/build/io/io-queue.js',
            'include/javascript/yui3/build/io/io-upload-iframe-min.js',
            'include/javascript/yui3/build/io/io-upload-iframe.js',
            'include/javascript/yui3/build/io/io-xdr-min.js',
            'include/javascript/yui3/build/io/io-xdr.js',
            'include/javascript/yui3/build/io/io.js',
            'include/javascript/yui3/build/io/io.swf',
            'include/javascript/yui3/build/json/json-min.js',
            'include/javascript/yui3/build/json/json-parse-min.js',
            'include/javascript/yui3/build/json/json-parse.js',
            'include/javascript/yui3/build/json/json-stringify-min.js',
            'include/javascript/yui3/build/json/json-stringify.js',
            'include/javascript/yui3/build/json/json.js',
            'include/javascript/yui3/build/jsonp/jsonp-min.js',
            'include/javascript/yui3/build/jsonp/jsonp-url-min.js',
            'include/javascript/yui3/build/jsonp/jsonp-url.js',
            'include/javascript/yui3/build/jsonp/jsonp.js',
            'include/javascript/yui3/build/loader/loader-base-min.js',
            'include/javascript/yui3/build/loader/loader-base.js',
            'include/javascript/yui3/build/loader/loader-min.js',
            'include/javascript/yui3/build/loader/loader-rollup-min.js',
            'include/javascript/yui3/build/loader/loader-rollup.js',
            'include/javascript/yui3/build/loader/loader-yui3-min.js',
            'include/javascript/yui3/build/loader/loader-yui3.js',
            'include/javascript/yui3/build/loader/loader.js',
            'include/javascript/yui3/build/node-flick/assets/node-flick-core.css',
            'include/javascript/yui3/build/node-flick/assets/skins/sam/node-flick-skin.css',
            'include/javascript/yui3/build/node-flick/assets/skins/sam/node-flick.css',
            'include/javascript/yui3/build/node-flick/node-flick-min.js',
            'include/javascript/yui3/build/node-flick/node-flick.js',
            'include/javascript/yui3/build/node-focusmanager/node-focusmanager-min.js',
            'include/javascript/yui3/build/node-focusmanager/node-focusmanager.js',
            'include/javascript/yui3/build/node-menunav/assets/node-menunav-core.css',
            'include/javascript/yui3/build/node-menunav/assets/skins/sam/horizontal-menu-submenu-indicator.png',
            'include/javascript/yui3/build/node-menunav/assets/skins/sam/horizontal-menu-submenu-toggle.png',
            'include/javascript/yui3/build/node-menunav/assets/skins/sam/node-menunav-skin.css',
            'include/javascript/yui3/build/node-menunav/assets/skins/sam/node-menunav.css',
            'include/javascript/yui3/build/node-menunav/assets/skins/sam/vertical-menu-submenu-indicator.png',
            'include/javascript/yui3/build/node-menunav/node-menunav-min.js',
            'include/javascript/yui3/build/node-menunav/node-menunav.js',
            'include/javascript/yui3/build/node/align-plugin-min.js',
            'include/javascript/yui3/build/node/align-plugin.js',
            'include/javascript/yui3/build/node/node-base-min.js',
            'include/javascript/yui3/build/node/node-base.js',
            'include/javascript/yui3/build/node/node-deprecated-min.js',
            'include/javascript/yui3/build/node/node-deprecated.js',
            'include/javascript/yui3/build/node/node-event-delegate-min.js',
            'include/javascript/yui3/build/node/node-event-delegate.js',
            'include/javascript/yui3/build/node/node-event-html5-min.js',
            'include/javascript/yui3/build/node/node-event-html5.js',
            'include/javascript/yui3/build/node/node-event-simulate-min.js',
            'include/javascript/yui3/build/node/node-event-simulate.js',
            'include/javascript/yui3/build/node/node-load-min.js',
            'include/javascript/yui3/build/node/node-load.js',
            'include/javascript/yui3/build/node/node-min.js',
            'include/javascript/yui3/build/node/node-pluginhost-min.js',
            'include/javascript/yui3/build/node/node-pluginhost.js',
            'include/javascript/yui3/build/node/node-screen-min.js',
            'include/javascript/yui3/build/node/node-screen.js',
            'include/javascript/yui3/build/node/node-style-min.js',
            'include/javascript/yui3/build/node/node-style.js',
            'include/javascript/yui3/build/node/node.js',
            'include/javascript/yui3/build/node/shim-plugin-min.js',
            'include/javascript/yui3/build/node/shim-plugin.js',
            'include/javascript/yui3/build/oop/oop-min.js',
            'include/javascript/yui3/build/oop/oop.js',
            'include/javascript/yui3/build/overlay/assets/overlay-core.css',
            'include/javascript/yui3/build/overlay/assets/skins/sam/overlay-skin.css',
            'include/javascript/yui3/build/overlay/assets/skins/sam/overlay.css',
            'include/javascript/yui3/build/overlay/overlay-min.js',
            'include/javascript/yui3/build/overlay/overlay.js',
            'include/javascript/yui3/build/plugin/plugin-min.js',
            'include/javascript/yui3/build/plugin/plugin.js',
            'include/javascript/yui3/build/pluginhost/pluginhost-base-min.js',
            'include/javascript/yui3/build/pluginhost/pluginhost-base.js',
            'include/javascript/yui3/build/pluginhost/pluginhost-config-min.js',
            'include/javascript/yui3/build/pluginhost/pluginhost-config.js',
            'include/javascript/yui3/build/pluginhost/pluginhost-min.js',
            'include/javascript/yui3/build/pluginhost/pluginhost.js',
            'include/javascript/yui3/build/profiler/profiler-min.js',
            'include/javascript/yui3/build/profiler/profiler.js',
            'include/javascript/yui3/build/querystring/querystring-min.js',
            'include/javascript/yui3/build/querystring/querystring-parse-min.js',
            'include/javascript/yui3/build/querystring/querystring-parse-simple-min.js',
            'include/javascript/yui3/build/querystring/querystring-parse-simple.js',
            'include/javascript/yui3/build/querystring/querystring-parse.js',
            'include/javascript/yui3/build/querystring/querystring-stringify-min.js',
            'include/javascript/yui3/build/querystring/querystring-stringify-simple-min.js',
            'include/javascript/yui3/build/querystring/querystring-stringify-simple.js',
            'include/javascript/yui3/build/querystring/querystring-stringify.js',
            'include/javascript/yui3/build/querystring/querystring.js',
            'include/javascript/yui3/build/queue-promote/queue-promote-min.js',
            'include/javascript/yui3/build/queue-promote/queue-promote.js',
            'include/javascript/yui3/build/recordset/recordset-base-min.js',
            'include/javascript/yui3/build/recordset/recordset-base.js',
            'include/javascript/yui3/build/recordset/recordset-filter-min.js',
            'include/javascript/yui3/build/recordset/recordset-filter.js',
            'include/javascript/yui3/build/recordset/recordset-indexer-min.js',
            'include/javascript/yui3/build/recordset/recordset-indexer.js',
            'include/javascript/yui3/build/recordset/recordset-min.js',
            'include/javascript/yui3/build/recordset/recordset-sort-min.js',
            'include/javascript/yui3/build/recordset/recordset-sort.js',
            'include/javascript/yui3/build/recordset/recordset.js',
            'include/javascript/yui3/build/resize/assets/resize-base-core.css',
            'include/javascript/yui3/build/resize/assets/skins/sam/arrows.png',
            'include/javascript/yui3/build/resize/assets/skins/sam/resize-base-skin.css',
            'include/javascript/yui3/build/resize/assets/skins/sam/resize-base.css',
            'include/javascript/yui3/build/resize/assets/skins/sam/resize.css',
            'include/javascript/yui3/build/resize/resize-base-min.js',
            'include/javascript/yui3/build/resize/resize-base.js',
            'include/javascript/yui3/build/resize/resize-constrain-min.js',
            'include/javascript/yui3/build/resize/resize-constrain.js',
            'include/javascript/yui3/build/resize/resize-min.js',
            'include/javascript/yui3/build/resize/resize-proxy-min.js',
            'include/javascript/yui3/build/resize/resize-proxy.js',
            'include/javascript/yui3/build/resize/resize.js',
            'include/javascript/yui3/build/scrollview/assets/scrollview-base-core.css',
            'include/javascript/yui3/build/scrollview/assets/scrollview-paginator-core.css',
            'include/javascript/yui3/build/scrollview/assets/scrollview-scrollbars-core.css',
            'include/javascript/yui3/build/scrollview/assets/skins/sam/scrollview-base-skin.css',
            'include/javascript/yui3/build/scrollview/assets/skins/sam/scrollview-base.css',
            'include/javascript/yui3/build/scrollview/assets/skins/sam/scrollview-paginator-skin.css',
            'include/javascript/yui3/build/scrollview/assets/skins/sam/scrollview-paginator.css',
            'include/javascript/yui3/build/scrollview/assets/skins/sam/scrollview-scrollbars-skin.css',
            'include/javascript/yui3/build/scrollview/assets/skins/sam/scrollview-scrollbars.css',
            'include/javascript/yui3/build/scrollview/scrollview-base-ie-min.js',
            'include/javascript/yui3/build/scrollview/scrollview-base-ie.js',
            'include/javascript/yui3/build/scrollview/scrollview-base-min.js',
            'include/javascript/yui3/build/scrollview/scrollview-base.js',
            'include/javascript/yui3/build/scrollview/scrollview-min.js',
            'include/javascript/yui3/build/scrollview/scrollview-paginator-min.js',
            'include/javascript/yui3/build/scrollview/scrollview-paginator.js',
            'include/javascript/yui3/build/scrollview/scrollview-scrollbars-min.js',
            'include/javascript/yui3/build/scrollview/scrollview-scrollbars.js',
            'include/javascript/yui3/build/scrollview/scrollview.js',
            'include/javascript/yui3/build/simpleyui/simpleyui-min.js',
            'include/javascript/yui3/build/simpleyui/simpleyui.js',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/audio-light/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/audio/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/audio/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/audio/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/audio/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/audio/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/audio/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/audio/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/audio/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/rail-x-dots.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/rail-x-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/rail-y-dots.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/rail-y-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/thumb-x-line.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/thumb-y-line.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule-dark/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/rail-x-dots.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/rail-x-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/rail-y-dots.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/rail-y-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/capsule/thumb-x-line.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/thumb-y-line.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/thumb-y-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/capsule/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/thumb-x-grip.png',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/thumb-y-grip.png',
            'include/javascript/yui3/build/slider/assets/skins/round-dark/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/round/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/round/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/round/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/round/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/round/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/round/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/round/thumb-x-grip.png',
            'include/javascript/yui3/build/slider/assets/skins/round/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/round/thumb-y-grip.png',
            'include/javascript/yui3/build/slider/assets/skins/round/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/rail-x-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/rail-y-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/sam-dark/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/rail-classic-x.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/rail-classic-y.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/rail-x-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/rail-x.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/rail-y-lines.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/rail-y.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/slider-base-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/sam/slider-base.css',
            'include/javascript/yui3/build/slider/assets/skins/sam/slider-skin.css',
            'include/javascript/yui3/build/slider/assets/skins/sam/slider.css',
            'include/javascript/yui3/build/slider/assets/skins/sam/thumb-classic-x.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/thumb-classic-y.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/thumb-x.png',
            'include/javascript/yui3/build/slider/assets/skins/sam/thumb-y.png',
            'include/javascript/yui3/build/slider/assets/slider-base-core.css',
            'include/javascript/yui3/build/slider/assets/slider-core.css',
            'include/javascript/yui3/build/slider/clickable-rail-min.js',
            'include/javascript/yui3/build/slider/clickable-rail.js',
            'include/javascript/yui3/build/slider/range-slider-min.js',
            'include/javascript/yui3/build/slider/range-slider.js',
            'include/javascript/yui3/build/slider/slider-base-min.js',
            'include/javascript/yui3/build/slider/slider-base.js',
            'include/javascript/yui3/build/slider/slider-min.js',
            'include/javascript/yui3/build/slider/slider-value-range-min.js',
            'include/javascript/yui3/build/slider/slider-value-range.js',
            'include/javascript/yui3/build/slider/slider.js',
            'include/javascript/yui3/build/sortable/sortable-min.js',
            'include/javascript/yui3/build/sortable/sortable-scroll-min.js',
            'include/javascript/yui3/build/sortable/sortable-scroll.js',
            'include/javascript/yui3/build/sortable/sortable.js',
            'include/javascript/yui3/build/stylesheet/stylesheet-min.js',
            'include/javascript/yui3/build/stylesheet/stylesheet.js',
            'include/javascript/yui3/build/substitute/substitute-min.js',
            'include/javascript/yui3/build/substitute/substitute.js',
            'include/javascript/yui3/build/swf/swf-min.js',
            'include/javascript/yui3/build/swf/swf.js',
            'include/javascript/yui3/build/swfdetect/swfdetect-min.js',
            'include/javascript/yui3/build/swfdetect/swfdetect.js',
            'include/javascript/yui3/build/tabview/assets/skins/sam/tabview-skin.css',
            'include/javascript/yui3/build/tabview/assets/skins/sam/tabview.css',
            'include/javascript/yui3/build/tabview/assets/tabview-core.css',
            'include/javascript/yui3/build/tabview/assets/tabview.css',
            'include/javascript/yui3/build/tabview/tabview-base-min.js',
            'include/javascript/yui3/build/tabview/tabview-base.js',
            'include/javascript/yui3/build/tabview/tabview-min.js',
            'include/javascript/yui3/build/tabview/tabview-plugin-min.js',
            'include/javascript/yui3/build/tabview/tabview-plugin.js',
            'include/javascript/yui3/build/tabview/tabview.js',
            'include/javascript/yui3/build/test/assets/skins/sam/test-skin.css',
            'include/javascript/yui3/build/test/assets/skins/sam/test.css',
            'include/javascript/yui3/build/test/assets/test-console.css',
            'include/javascript/yui3/build/test/test-min.js',
            'include/javascript/yui3/build/test/test.js',
            'include/javascript/yui3/build/text/text-accentfold-min.js',
            'include/javascript/yui3/build/text/text-accentfold.js',
            'include/javascript/yui3/build/text/text-data-accentfold-min.js',
            'include/javascript/yui3/build/text/text-data-accentfold.js',
            'include/javascript/yui3/build/text/text-data-wordbreak-min.js',
            'include/javascript/yui3/build/text/text-data-wordbreak.js',
            'include/javascript/yui3/build/text/text-min.js',
            'include/javascript/yui3/build/text/text-wordbreak-min.js',
            'include/javascript/yui3/build/text/text-wordbreak.js',
            'include/javascript/yui3/build/text/text.js',
            'include/javascript/yui3/build/transition/transition-min.js',
            'include/javascript/yui3/build/transition/transition-native-min.js',
            'include/javascript/yui3/build/transition/transition-native.js',
            'include/javascript/yui3/build/transition/transition-timer-min.js',
            'include/javascript/yui3/build/transition/transition-timer.js',
            'include/javascript/yui3/build/transition/transition.js',
            'include/javascript/yui3/build/uploader/assets/uploader.swf',
            'include/javascript/yui3/build/uploader/uploader-min.js',
            'include/javascript/yui3/build/uploader/uploader.js',
            'include/javascript/yui3/build/widget-anim/widget-anim-min.js',
            'include/javascript/yui3/build/widget-anim/widget-anim.js',
            'include/javascript/yui3/build/widget/assets/skins/sam/widget-base-skin.css',
            'include/javascript/yui3/build/widget/assets/skins/sam/widget-base.css',
            'include/javascript/yui3/build/widget/assets/skins/sam/widget-stack-skin.css',
            'include/javascript/yui3/build/widget/assets/skins/sam/widget-stack.css',
            'include/javascript/yui3/build/widget/assets/skins/sam/widget.css',
            'include/javascript/yui3/build/widget/assets/widget-base-core.css',
            'include/javascript/yui3/build/widget/assets/widget-stack-core.css',
            'include/javascript/yui3/build/widget/widget-base-ie-min.js',
            'include/javascript/yui3/build/widget/widget-base-ie.js',
            'include/javascript/yui3/build/widget/widget-base-min.js',
            'include/javascript/yui3/build/widget/widget-base.js',
            'include/javascript/yui3/build/widget/widget-child-min.js',
            'include/javascript/yui3/build/widget/widget-child.js',
            'include/javascript/yui3/build/widget/widget-htmlparser-min.js',
            'include/javascript/yui3/build/widget/widget-htmlparser.js',
            'include/javascript/yui3/build/widget/widget-locale-min.js',
            'include/javascript/yui3/build/widget/widget-locale.js',
            'include/javascript/yui3/build/widget/widget-min.js',
            'include/javascript/yui3/build/widget/widget-parent-min.js',
            'include/javascript/yui3/build/widget/widget-parent.js',
            'include/javascript/yui3/build/widget/widget-position-align-min.js',
            'include/javascript/yui3/build/widget/widget-position-align.js',
            'include/javascript/yui3/build/widget/widget-position-constrain-min.js',
            'include/javascript/yui3/build/widget/widget-position-constrain.js',
            'include/javascript/yui3/build/widget/widget-position-min.js',
            'include/javascript/yui3/build/widget/widget-position.js',
            'include/javascript/yui3/build/widget/widget-skin-min.js',
            'include/javascript/yui3/build/widget/widget-skin.js',
            'include/javascript/yui3/build/widget/widget-stack-min.js',
            'include/javascript/yui3/build/widget/widget-stack.js',
            'include/javascript/yui3/build/widget/widget-stdmod-min.js',
            'include/javascript/yui3/build/widget/widget-stdmod.js',
            'include/javascript/yui3/build/widget/widget-uievents-min.js',
            'include/javascript/yui3/build/widget/widget-uievents.js',
            'include/javascript/yui3/build/widget/widget.js',
            'include/javascript/yui3/build/yql/yql-min.js',
            'include/javascript/yui3/build/yql/yql.js',
            'include/javascript/yui3/build/yui/features-min.js',
            'include/javascript/yui3/build/yui/features.js',
            'include/javascript/yui3/build/yui/get-min.js',
            'include/javascript/yui3/build/yui/get.js',
            'include/javascript/yui3/build/yui/intl-base-min.js',
            'include/javascript/yui3/build/yui/intl-base.js',
            'include/javascript/yui3/build/yui/rls-min.js',
            'include/javascript/yui3/build/yui/rls.js',
            'include/javascript/yui3/build/yui/yui-base-min.js',
            'include/javascript/yui3/build/yui/yui-base.js',
            'include/javascript/yui3/build/yui/yui-later-min.js',
            'include/javascript/yui3/build/yui/yui-later.js',
            'include/javascript/yui3/build/yui/yui-log-min.js',
            'include/javascript/yui3/build/yui/yui-log.js',
            'include/javascript/yui3/build/yui/yui-min.js',
            'include/javascript/yui3/build/yui/yui-throttle-min.js',
            'include/javascript/yui3/build/yui/yui-throttle.js',
            'include/javascript/yui3/build/yui/yui.js',
            'include/javascript/yui3/index.html',
            'include/pclzip/gnu-lgpl.txt',
            'include/pclzip/pclzip.lib.php',
            'include/pclzip/readme.txt',
            'include/phpmailer/LICENSE',
            'include/phpmailer/VERSION',
            'include/phpmailer/class.phpmailer.php',
            'include/phpmailer/class.smtp.php',
            'include/phpmailer/extras/htmlfilter.php',
            'include/phpmailer/language/phpmailer.lang-ar.php',
            'include/phpmailer/language/phpmailer.lang-br.php',
            'include/phpmailer/language/phpmailer.lang-ca.php',
            'include/phpmailer/language/phpmailer.lang-ch.php',
            'include/phpmailer/language/phpmailer.lang-cz.php',
            'include/phpmailer/language/phpmailer.lang-de.php',
            'include/phpmailer/language/phpmailer.lang-dk.php',
            'include/phpmailer/language/phpmailer.lang-es.php',
            'include/phpmailer/language/phpmailer.lang-et.php',
            'include/phpmailer/language/phpmailer.lang-fi.php',
            'include/phpmailer/language/phpmailer.lang-fo.php',
            'include/phpmailer/language/phpmailer.lang-fr.php',
            'include/phpmailer/language/phpmailer.lang-hu.php',
            'include/phpmailer/language/phpmailer.lang-it.php',
            'include/phpmailer/language/phpmailer.lang-ja.php',
            'include/phpmailer/language/phpmailer.lang-nl.php',
            'include/phpmailer/language/phpmailer.lang-no.php',
            'include/phpmailer/language/phpmailer.lang-pl.php',
            'include/phpmailer/language/phpmailer.lang-ro.php',
            'include/phpmailer/language/phpmailer.lang-ru.php',
            'include/phpmailer/language/phpmailer.lang-se.php',
            'include/phpmailer/language/phpmailer.lang-tr.php',
            'include/phpmailer/language/phpmailer.lang-zh.php',
            'include/phpmailer/language/phpmailer.lang-zh_cn.php',
            'include/reCaptcha/LICENSE',
            'include/reCaptcha/README',
            'include/reCaptcha/recaptchalib.php',
            'include/tcpdf/CHANGELOG.TXT',
            'include/tcpdf/LICENSE.TXT',
            'include/tcpdf/README.TXT',
            'include/utils/zip_utils.php',
            'jssource/Minifier.php',
            'jssource/src_files/include/HTMLPurifier/standalone/HTMLPurifier/Printer/ConfigForm.js',
            'jssource/src_files/include/SugarCharts/Jit/js/sugarCharts.js',
            'jssource/src_files/include/SugarEmailAddress/SugarEmailAddressLegacy.js',
            'jssource/src_files/include/javascript/yui3/assets/dpSyntaxHighlighter.js',
            'jssource/src_files/include/javascript/yui3/assets/syntax.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-base.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-color-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-color.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-curve-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-curve.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-easing-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-easing.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-node-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-node-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-scroll-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-scroll.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-xy-min.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim-xy.js',
            'jssource/src_files/include/javascript/yui3/build/anim/anim.js',
            'jssource/src_files/include/javascript/yui3/build/arraysort/arraysort-min.js',
            'jssource/src_files/include/javascript/yui3/build/arraysort/arraysort.js',
            'jssource/src_files/include/javascript/yui3/build/async-queue/async-queue-min.js',
            'jssource/src_files/include/javascript/yui3/build/async-queue/async-queue.js',
            'jssource/src_files/include/javascript/yui3/build/attribute/attribute-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/attribute/attribute-base.js',
            'jssource/src_files/include/javascript/yui3/build/attribute/attribute-complex-min.js',
            'jssource/src_files/include/javascript/yui3/build/attribute/attribute-complex.js',
            'jssource/src_files/include/javascript/yui3/build/attribute/attribute-min.js',
            'jssource/src_files/include/javascript/yui3/build/attribute/attribute.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-base.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-filters-accentfold-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-filters-accentfold.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-filters-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-filters.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-highlighters-accentfold-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-highlighters-accentfold.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-highlighters-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-highlighters.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-list-keys-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-list-keys.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-list-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-list.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-sources-min.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete-sources.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/autocomplete.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/lang/autocomplete-list.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/lang/autocomplete-list_en.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/lang/autocomplete.js',
            'jssource/src_files/include/javascript/yui3/build/autocomplete/lang/autocomplete_en.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-base.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-build-min.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-build.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-min.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-pluginhost-min.js',
            'jssource/src_files/include/javascript/yui3/build/base/base-pluginhost.js',
            'jssource/src_files/include/javascript/yui3/build/base/base.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-base.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-min.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-offline-min.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-offline.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/cache/cache.js',
            'jssource/src_files/include/javascript/yui3/build/charts/charts-min.js',
            'jssource/src_files/include/javascript/yui3/build/charts/charts.js',
            'jssource/src_files/include/javascript/yui3/build/classnamemanager/classnamemanager-min.js',
            'jssource/src_files/include/javascript/yui3/build/classnamemanager/classnamemanager.js',
            'jssource/src_files/include/javascript/yui3/build/collection/array-extras-min.js',
            'jssource/src_files/include/javascript/yui3/build/collection/array-extras.js',
            'jssource/src_files/include/javascript/yui3/build/collection/array-invoke-min.js',
            'jssource/src_files/include/javascript/yui3/build/collection/array-invoke.js',
            'jssource/src_files/include/javascript/yui3/build/collection/arraylist-add-min.js',
            'jssource/src_files/include/javascript/yui3/build/collection/arraylist-add.js',
            'jssource/src_files/include/javascript/yui3/build/collection/arraylist-filter-min.js',
            'jssource/src_files/include/javascript/yui3/build/collection/arraylist-filter.js',
            'jssource/src_files/include/javascript/yui3/build/collection/arraylist-min.js',
            'jssource/src_files/include/javascript/yui3/build/collection/arraylist.js',
            'jssource/src_files/include/javascript/yui3/build/collection/collection-min.js',
            'jssource/src_files/include/javascript/yui3/build/collection/collection.js',
            'jssource/src_files/include/javascript/yui3/build/compat/compat-min.js',
            'jssource/src_files/include/javascript/yui3/build/compat/compat.js',
            'jssource/src_files/include/javascript/yui3/build/console/console-filters-min.js',
            'jssource/src_files/include/javascript/yui3/build/console/console-filters.js',
            'jssource/src_files/include/javascript/yui3/build/console/console-min.js',
            'jssource/src_files/include/javascript/yui3/build/console/console.js',
            'jssource/src_files/include/javascript/yui3/build/console/lang/console.js',
            'jssource/src_files/include/javascript/yui3/build/console/lang/console_en.js',
            'jssource/src_files/include/javascript/yui3/build/console/lang/console_es.js',
            'jssource/src_files/include/javascript/yui3/build/cookie/cookie-min.js',
            'jssource/src_files/include/javascript/yui3/build/cookie/cookie.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-array-min.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-array.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-base.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-json-min.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-json.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-min.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-text-min.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-text.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-xml-min.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema-xml.js',
            'jssource/src_files/include/javascript/yui3/build/dataschema/dataschema.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-arrayschema-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-arrayschema.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-cache-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-cache.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-function-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-function.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-get-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-get.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-io-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-io.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-jsonschema-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-jsonschema.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-local-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-local.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-polling-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-polling.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-textschema-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-textschema.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-xmlschema-min.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource-xmlschema.js',
            'jssource/src_files/include/javascript/yui3/build/datasource/datasource.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-base.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-datasource-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-datasource.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-scroll-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-scroll.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-sort-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable-sort.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/datatable.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/lang/datatable-base.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/lang/datatable-base_en.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/lang/datatable-sort.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/lang/datatable-sort_en.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/lang/datatable.js',
            'jssource/src_files/include/javascript/yui3/build/datatable/lang/datatable_en.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-date-format-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-date-format.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-date-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-date-parse-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-date-parse.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-date.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-number-format-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-number-format.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-number-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-number-parse-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-number-parse.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-number.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-xml-format-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-xml-format.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-xml-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-xml-parse-min.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-xml-parse.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype-xml.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/datatype.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ar-JO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ar.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ca-ES.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ca.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_da-DK.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_da.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_de-AT.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_de-DE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_de.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_el-GR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_el.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-AU.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-CA.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-GB.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-IE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-IN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-JO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-MY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-NZ.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-PH.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-SG.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en-US.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_en.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-AR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-BO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-CL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-CO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-EC.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-ES.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-MX.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-PE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-PY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-US.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-UY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es-VE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_es.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_fi-FI.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_fi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_fr-BE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_fr-CA.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_fr-FR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_fr.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_hi-IN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_hi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_id-ID.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_id.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_it-IT.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_it.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ja-JP.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ja.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ko-KR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ko.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ms-MY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ms.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_nb-NO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_nb.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_nl-BE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_nl-NL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_nl.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_pl-PL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_pl.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_pt-BR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_pt.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ro-RO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ro.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ru-RU.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_ru.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_sv-SE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_sv.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_th-TH.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_th.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_tr-TR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_tr.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_vi-VN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_vi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hans-CN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hans.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hant-HK.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hant-TW.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date-format_zh-Hant.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ar-JO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ar.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ca-ES.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ca.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_da-DK.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_da.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_de-AT.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_de-DE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_de.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_el-GR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_el.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-AU.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-CA.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-GB.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-IE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-IN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-JO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-MY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-NZ.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-PH.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-SG.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en-US.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_en.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-AR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-BO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-CL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-CO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-EC.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-ES.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-MX.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-PE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-PY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-US.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-UY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es-VE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_es.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_fi-FI.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_fi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_fr-BE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_fr-CA.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_fr-FR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_fr.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_hi-IN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_hi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_id-ID.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_id.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_it-IT.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_it.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ja-JP.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ja.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ko-KR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ko.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ms-MY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ms.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_nb-NO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_nb.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_nl-BE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_nl-NL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_nl.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_pl-PL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_pl.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_pt-BR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_pt.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ro-RO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ro.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ru-RU.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_ru.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_sv-SE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_sv.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_th-TH.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_th.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_tr-TR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_tr.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_vi-VN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_vi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hans-CN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hans.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hant-HK.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hant-TW.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype-date_zh-Hant.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ar-JO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ar.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ca-ES.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ca.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_da-DK.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_da.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_de-AT.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_de-DE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_de.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_el-GR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_el.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-AU.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-CA.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-GB.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-IE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-IN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-JO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-MY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-NZ.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-PH.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-SG.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en-US.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_en.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-AR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-BO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-CL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-CO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-EC.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-ES.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-MX.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-PE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-PY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-US.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-UY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es-VE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_es.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_fi-FI.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_fi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_fr-BE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_fr-CA.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_fr-FR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_fr.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_hi-IN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_hi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_id-ID.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_id.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_it-IT.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_it.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ja-JP.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ja.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ko-KR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ko.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ms-MY.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ms.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_nb-NO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_nb.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_nl-BE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_nl-NL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_nl.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_pl-PL.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_pl.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_pt-BR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_pt.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ro-RO.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ro.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ru-RU.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_ru.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_sv-SE.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_sv.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_th-TH.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_th.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_tr-TR.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_tr.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_vi-VN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_vi.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_zh-Hans-CN.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_zh-Hans.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_zh-Hant-HK.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_zh-Hant-TW.js',
            'jssource/src_files/include/javascript/yui3/build/datatype/lang/datatype_zh-Hant.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-constrain-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-constrain.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-ddm-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-ddm-base.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-ddm-drop-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-ddm-drop.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-ddm-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-ddm.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-delegate-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-delegate.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-drag-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-drag.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-drop-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-drop-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-drop-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-drop.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-gestures-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-gestures.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-proxy-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-proxy.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-scroll-min.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd-scroll.js',
            'jssource/src_files/include/javascript/yui3/build/dd/dd.js',
            'jssource/src_files/include/javascript/yui3/build/dial/dial-min.js',
            'jssource/src_files/include/javascript/yui3/build/dial/dial.js',
            'jssource/src_files/include/javascript/yui3/build/dial/lang/dial.js',
            'jssource/src_files/include/javascript/yui3/build/dial/lang/dial_en.js',
            'jssource/src_files/include/javascript/yui3/build/dial/lang/dial_es.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-base.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-deprecated-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-deprecated.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-screen-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-screen.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-style-ie-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-style-ie.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-style-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom-style.js',
            'jssource/src_files/include/javascript/yui3/build/dom/dom.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-css2-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-css2.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-css3-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-css3.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-native-min.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector-native.js',
            'jssource/src_files/include/javascript/yui3/build/dom/selector.js',
            'jssource/src_files/include/javascript/yui3/build/dump/dump-min.js',
            'jssource/src_files/include/javascript/yui3/build/dump/dump.js',
            'jssource/src_files/include/javascript/yui3/build/editor/createlink-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/createlink-base.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-base.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-bidi-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-bidi.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-br-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-br.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-lists-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-lists.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-para-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-para.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-tab-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor-tab.js',
            'jssource/src_files/include/javascript/yui3/build/editor/editor.js',
            'jssource/src_files/include/javascript/yui3/build/editor/exec-command-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/exec-command.js',
            'jssource/src_files/include/javascript/yui3/build/editor/frame-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/frame.js',
            'jssource/src_files/include/javascript/yui3/build/editor/selection-min.js',
            'jssource/src_files/include/javascript/yui3/build/editor/selection.js',
            'jssource/src_files/include/javascript/yui3/build/escape/escape-min.js',
            'jssource/src_files/include/javascript/yui3/build/escape/escape.js',
            'jssource/src_files/include/javascript/yui3/build/event-custom/event-custom-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-custom/event-custom-base.js',
            'jssource/src_files/include/javascript/yui3/build/event-custom/event-custom-complex-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-custom/event-custom-complex.js',
            'jssource/src_files/include/javascript/yui3/build/event-custom/event-custom-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-custom/event-custom.js',
            'jssource/src_files/include/javascript/yui3/build/event-gestures/event-flick-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-gestures/event-flick.js',
            'jssource/src_files/include/javascript/yui3/build/event-gestures/event-gestures-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-gestures/event-gestures.js',
            'jssource/src_files/include/javascript/yui3/build/event-gestures/event-move-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-gestures/event-move.js',
            'jssource/src_files/include/javascript/yui3/build/event-simulate/event-simulate-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-simulate/event-simulate.js',
            'jssource/src_files/include/javascript/yui3/build/event-valuechange/event-valuechange-min.js',
            'jssource/src_files/include/javascript/yui3/build/event-valuechange/event-valuechange.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-base-ie-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-base-ie.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-base.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-delegate-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-delegate.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-focus-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-focus.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-hover-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-hover.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-key-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-key.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-mouseenter-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-mouseenter.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-mousewheel-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-mousewheel.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-resize-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-resize.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-synthetic-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-synthetic.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-touch-min.js',
            'jssource/src_files/include/javascript/yui3/build/event/event-touch.js',
            'jssource/src_files/include/javascript/yui3/build/event/event.js',
            'jssource/src_files/include/javascript/yui3/build/highlight/highlight-accentfold-min.js',
            'jssource/src_files/include/javascript/yui3/build/highlight/highlight-accentfold.js',
            'jssource/src_files/include/javascript/yui3/build/highlight/highlight-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/highlight/highlight-base.js',
            'jssource/src_files/include/javascript/yui3/build/highlight/highlight-min.js',
            'jssource/src_files/include/javascript/yui3/build/highlight/highlight.js',
            'jssource/src_files/include/javascript/yui3/build/history-deprecated/history-deprecated-min.js',
            'jssource/src_files/include/javascript/yui3/build/history-deprecated/history-deprecated.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-base.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-hash-ie-min.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-hash-ie.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-hash-min.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-hash.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-html5-min.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-html5.js',
            'jssource/src_files/include/javascript/yui3/build/history/history-min.js',
            'jssource/src_files/include/javascript/yui3/build/history/history.js',
            'jssource/src_files/include/javascript/yui3/build/imageloader/imageloader-min.js',
            'jssource/src_files/include/javascript/yui3/build/imageloader/imageloader.js',
            'jssource/src_files/include/javascript/yui3/build/intl/intl-min.js',
            'jssource/src_files/include/javascript/yui3/build/intl/intl.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-base.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-form-min.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-form.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-min.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-queue-min.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-queue.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-upload-iframe-min.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-upload-iframe.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-xdr-min.js',
            'jssource/src_files/include/javascript/yui3/build/io/io-xdr.js',
            'jssource/src_files/include/javascript/yui3/build/io/io.js',
            'jssource/src_files/include/javascript/yui3/build/json/json-min.js',
            'jssource/src_files/include/javascript/yui3/build/json/json-parse-min.js',
            'jssource/src_files/include/javascript/yui3/build/json/json-parse.js',
            'jssource/src_files/include/javascript/yui3/build/json/json-stringify-min.js',
            'jssource/src_files/include/javascript/yui3/build/json/json-stringify.js',
            'jssource/src_files/include/javascript/yui3/build/json/json.js',
            'jssource/src_files/include/javascript/yui3/build/jsonp/jsonp-min.js',
            'jssource/src_files/include/javascript/yui3/build/jsonp/jsonp-url-min.js',
            'jssource/src_files/include/javascript/yui3/build/jsonp/jsonp-url.js',
            'jssource/src_files/include/javascript/yui3/build/jsonp/jsonp.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-base.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-min.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-rollup-min.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-rollup.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-yui3-min.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader-yui3.js',
            'jssource/src_files/include/javascript/yui3/build/loader/loader.js',
            'jssource/src_files/include/javascript/yui3/build/node-flick/node-flick-min.js',
            'jssource/src_files/include/javascript/yui3/build/node-flick/node-flick.js',
            'jssource/src_files/include/javascript/yui3/build/node-focusmanager/node-focusmanager-min.js',
            'jssource/src_files/include/javascript/yui3/build/node-focusmanager/node-focusmanager.js',
            'jssource/src_files/include/javascript/yui3/build/node-menunav/node-menunav-min.js',
            'jssource/src_files/include/javascript/yui3/build/node-menunav/node-menunav.js',
            'jssource/src_files/include/javascript/yui3/build/node/align-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/align-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-base.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-deprecated-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-deprecated.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-event-delegate-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-event-delegate.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-event-html5-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-event-html5.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-event-simulate-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-event-simulate.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-load-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-load.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-pluginhost-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-pluginhost.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-screen-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-screen.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-style-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/node-style.js',
            'jssource/src_files/include/javascript/yui3/build/node/node.js',
            'jssource/src_files/include/javascript/yui3/build/node/shim-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/node/shim-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/oop/oop-min.js',
            'jssource/src_files/include/javascript/yui3/build/oop/oop.js',
            'jssource/src_files/include/javascript/yui3/build/overlay/overlay-min.js',
            'jssource/src_files/include/javascript/yui3/build/overlay/overlay.js',
            'jssource/src_files/include/javascript/yui3/build/plugin/plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/plugin/plugin.js',
            'jssource/src_files/include/javascript/yui3/build/pluginhost/pluginhost-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/pluginhost/pluginhost-base.js',
            'jssource/src_files/include/javascript/yui3/build/pluginhost/pluginhost-config-min.js',
            'jssource/src_files/include/javascript/yui3/build/pluginhost/pluginhost-config.js',
            'jssource/src_files/include/javascript/yui3/build/pluginhost/pluginhost-min.js',
            'jssource/src_files/include/javascript/yui3/build/pluginhost/pluginhost.js',
            'jssource/src_files/include/javascript/yui3/build/profiler/profiler-min.js',
            'jssource/src_files/include/javascript/yui3/build/profiler/profiler.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-min.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-parse-min.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-parse-simple-min.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-parse-simple.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-parse.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-stringify-min.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-stringify-simple-min.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-stringify-simple.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring-stringify.js',
            'jssource/src_files/include/javascript/yui3/build/querystring/querystring.js',
            'jssource/src_files/include/javascript/yui3/build/queue-promote/queue-promote-min.js',
            'jssource/src_files/include/javascript/yui3/build/queue-promote/queue-promote.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-base.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-filter-min.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-filter.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-indexer-min.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-indexer.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-min.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-sort-min.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset-sort.js',
            'jssource/src_files/include/javascript/yui3/build/recordset/recordset.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-base.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-constrain-min.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-constrain.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-min.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-proxy-min.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize-proxy.js',
            'jssource/src_files/include/javascript/yui3/build/resize/resize.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-base-ie-min.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-base-ie.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-base.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-min.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-paginator-min.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-paginator.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-scrollbars-min.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview-scrollbars.js',
            'jssource/src_files/include/javascript/yui3/build/scrollview/scrollview.js',
            'jssource/src_files/include/javascript/yui3/build/simpleyui/simpleyui-min.js',
            'jssource/src_files/include/javascript/yui3/build/simpleyui/simpleyui.js',
            'jssource/src_files/include/javascript/yui3/build/slider/clickable-rail-min.js',
            'jssource/src_files/include/javascript/yui3/build/slider/clickable-rail.js',
            'jssource/src_files/include/javascript/yui3/build/slider/range-slider-min.js',
            'jssource/src_files/include/javascript/yui3/build/slider/range-slider.js',
            'jssource/src_files/include/javascript/yui3/build/slider/slider-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/slider/slider-base.js',
            'jssource/src_files/include/javascript/yui3/build/slider/slider-min.js',
            'jssource/src_files/include/javascript/yui3/build/slider/slider-value-range-min.js',
            'jssource/src_files/include/javascript/yui3/build/slider/slider-value-range.js',
            'jssource/src_files/include/javascript/yui3/build/slider/slider.js',
            'jssource/src_files/include/javascript/yui3/build/sortable/sortable-min.js',
            'jssource/src_files/include/javascript/yui3/build/sortable/sortable-scroll-min.js',
            'jssource/src_files/include/javascript/yui3/build/sortable/sortable-scroll.js',
            'jssource/src_files/include/javascript/yui3/build/sortable/sortable.js',
            'jssource/src_files/include/javascript/yui3/build/stylesheet/stylesheet-min.js',
            'jssource/src_files/include/javascript/yui3/build/stylesheet/stylesheet.js',
            'jssource/src_files/include/javascript/yui3/build/substitute/substitute-min.js',
            'jssource/src_files/include/javascript/yui3/build/substitute/substitute.js',
            'jssource/src_files/include/javascript/yui3/build/swf/swf-min.js',
            'jssource/src_files/include/javascript/yui3/build/swf/swf.js',
            'jssource/src_files/include/javascript/yui3/build/swfdetect/swfdetect-min.js',
            'jssource/src_files/include/javascript/yui3/build/swfdetect/swfdetect.js',
            'jssource/src_files/include/javascript/yui3/build/tabview/tabview-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/tabview/tabview-base.js',
            'jssource/src_files/include/javascript/yui3/build/tabview/tabview-min.js',
            'jssource/src_files/include/javascript/yui3/build/tabview/tabview-plugin-min.js',
            'jssource/src_files/include/javascript/yui3/build/tabview/tabview-plugin.js',
            'jssource/src_files/include/javascript/yui3/build/tabview/tabview.js',
            'jssource/src_files/include/javascript/yui3/build/test/test-min.js',
            'jssource/src_files/include/javascript/yui3/build/test/test.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-accentfold-min.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-accentfold.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-data-accentfold-min.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-data-accentfold.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-data-wordbreak-min.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-data-wordbreak.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-min.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-wordbreak-min.js',
            'jssource/src_files/include/javascript/yui3/build/text/text-wordbreak.js',
            'jssource/src_files/include/javascript/yui3/build/text/text.js',
            'jssource/src_files/include/javascript/yui3/build/transition/transition-min.js',
            'jssource/src_files/include/javascript/yui3/build/transition/transition-native-min.js',
            'jssource/src_files/include/javascript/yui3/build/transition/transition-native.js',
            'jssource/src_files/include/javascript/yui3/build/transition/transition-timer-min.js',
            'jssource/src_files/include/javascript/yui3/build/transition/transition-timer.js',
            'jssource/src_files/include/javascript/yui3/build/transition/transition.js',
            'jssource/src_files/include/javascript/yui3/build/uploader/uploader-min.js',
            'jssource/src_files/include/javascript/yui3/build/uploader/uploader.js',
            'jssource/src_files/include/javascript/yui3/build/widget-anim/widget-anim-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget-anim/widget-anim.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-base-ie-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-base-ie.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-base.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-child-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-child.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-htmlparser-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-htmlparser.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-locale-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-locale.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-parent-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-parent.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-position-align-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-position-align.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-position-constrain-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-position-constrain.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-position-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-position.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-skin-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-skin.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-stack-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-stack.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-stdmod-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-stdmod.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-uievents-min.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget-uievents.js',
            'jssource/src_files/include/javascript/yui3/build/widget/widget.js',
            'jssource/src_files/include/javascript/yui3/build/yql/yql-min.js',
            'jssource/src_files/include/javascript/yui3/build/yql/yql.js',
            'jssource/src_files/include/javascript/yui3/build/yui/features-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/features.js',
            'jssource/src_files/include/javascript/yui3/build/yui/get-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/get.js',
            'jssource/src_files/include/javascript/yui3/build/yui/intl-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/intl-base.js',
            'jssource/src_files/include/javascript/yui3/build/yui/rls-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/rls.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-base-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-base.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-later-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-later.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-log-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-log.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-throttle-min.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui-throttle.js',
            'jssource/src_files/include/javascript/yui3/build/yui/yui.js',
            'lib/Search/ElasticSearch/defaultParams.yml',
            'modules/Activities/SubPanelView.html',
            'modules/Activities/SubPanelView.php',
            'modules/Activities/SubPanelViewContacts.html',
            'modules/Administration/AODAdmin.php',
            'modules/Administration/AODAdmin.tpl',
            'modules/Administration/Search/ajaxSubmit.js',
            'modules/Administration/Search/scripts.js',
            'modules/Administration/templates/GlobalSearchSettings.tpl',
            'modules/Calendar/fullcalendar/changelog.txt',
            'modules/Calendar/fullcalendar/lang-all.js',
            'modules/Calendar/fullcalendar/lang/ar-ma.js',
            'modules/Calendar/fullcalendar/lang/ar-sa.js',
            'modules/Calendar/fullcalendar/lang/ar-tn.js',
            'modules/Calendar/fullcalendar/lang/ar.js',
            'modules/Calendar/fullcalendar/lang/bg.js',
            'modules/Calendar/fullcalendar/lang/ca.js',
            'modules/Calendar/fullcalendar/lang/cs.js',
            'modules/Calendar/fullcalendar/lang/da.js',
            'modules/Calendar/fullcalendar/lang/de-at.js',
            'modules/Calendar/fullcalendar/lang/de.js',
            'modules/Calendar/fullcalendar/lang/el.js',
            'modules/Calendar/fullcalendar/lang/en-au.js',
            'modules/Calendar/fullcalendar/lang/en-ca.js',
            'modules/Calendar/fullcalendar/lang/en-gb.js',
            'modules/Calendar/fullcalendar/lang/es.js',
            'modules/Calendar/fullcalendar/lang/fa.js',
            'modules/Calendar/fullcalendar/lang/fi.js',
            'modules/Calendar/fullcalendar/lang/fr-ca.js',
            'modules/Calendar/fullcalendar/lang/fr.js',
            'modules/Calendar/fullcalendar/lang/he.js',
            'modules/Calendar/fullcalendar/lang/hi.js',
            'modules/Calendar/fullcalendar/lang/hr.js',
            'modules/Calendar/fullcalendar/lang/hu.js',
            'modules/Calendar/fullcalendar/lang/id.js',
            'modules/Calendar/fullcalendar/lang/is.js',
            'modules/Calendar/fullcalendar/lang/it.js',
            'modules/Calendar/fullcalendar/lang/ja.js',
            'modules/Calendar/fullcalendar/lang/ko.js',
            'modules/Calendar/fullcalendar/lang/lt.js',
            'modules/Calendar/fullcalendar/lang/lv.js',
            'modules/Calendar/fullcalendar/lang/nb.js',
            'modules/Calendar/fullcalendar/lang/nl.js',
            'modules/Calendar/fullcalendar/lang/pl.js',
            'modules/Calendar/fullcalendar/lang/pt-br.js',
            'modules/Calendar/fullcalendar/lang/pt.js',
            'modules/Calendar/fullcalendar/lang/ro.js',
            'modules/Calendar/fullcalendar/lang/ru.js',
            'modules/Calendar/fullcalendar/lang/sk.js',
            'modules/Calendar/fullcalendar/lang/sl.js',
            'modules/Calendar/fullcalendar/lang/sr-cyrl.js',
            'modules/Calendar/fullcalendar/lang/sr.js',
            'modules/Calendar/fullcalendar/lang/sv.js',
            'modules/Calendar/fullcalendar/lang/th.js',
            'modules/Calendar/fullcalendar/lang/tr.js',
            'modules/Calendar/fullcalendar/lang/uk.js',
            'modules/Calendar/fullcalendar/lang/vi.js',
            'modules/Calendar/fullcalendar/lang/zh-cn.js',
            'modules/Calendar/fullcalendar/lang/zh-tw.js',
            'modules/Calendar/fullcalendar/lib/cupertino/images/animated-overlay.gif',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_diagonals-thick_90_eeeeee_40x40.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_flat_15_cd0a0a_40x100.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_glass_100_e4f1fb_1x400.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_glass_50_3baae3_1x400.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_glass_80_d7ebf9_1x400.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_highlight-hard_100_f2f5f7_1x100.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_highlight-hard_70_000000_1x100.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_highlight-soft_100_deedf7_1x100.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-bg_highlight-soft_25_ffef8f_1x100.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-icons_2694e8_256x240.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-icons_2e83ff_256x240.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-icons_3d80b3_256x240.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-icons_72a7cf_256x240.png',
            'modules/Calendar/fullcalendar/lib/cupertino/images/ui-icons_ffffff_256x240.png',
            'modules/Calendar/fullcalendar/lib/cupertino/jquery-ui.min.css',
            'modules/Calendar/fullcalendar/lib/jquery-ui.custom.min.js',
            'modules/Calendar/fullcalendar/lib/jquery-ui.min.js',
            'modules/Calendar/fullcalendar/lib/jquery.min.js',
            'modules/Contacts/BusinessCard.html',
            'modules/Contacts/BusinessCard.php',
            'modules/Users/Save.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/CHANGELOG',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/LICENSE',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/README.md',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/_toolkit_loader.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/advanced_settings_example.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/certs/README',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/compatibility.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/endpoints/acs.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/endpoints/metadata.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/endpoints/sls.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/extlib/xmlseclibs/CHANGELOG.txt',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/extlib/xmlseclibs/LICENSE',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/extlib/xmlseclibs/xmlseclibs.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml/AuthRequest.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml/Metadata.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml/Response.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml/Settings.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml/XmlSec.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Auth.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/AuthnRequest.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Constants.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Error.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/IdPMetadataParser.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/LogoutRequest.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/LogoutResponse.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Metadata.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Response.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Settings.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/Utils.php',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/saml-schema-assertion-2.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/saml-schema-authn-context-2.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/saml-schema-authn-context-types-2.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/saml-schema-metadata-2.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/saml-schema-protocol-2.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/sstc-metadata-attr.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/sstc-saml-attribute-ext.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/sstc-saml-metadata-algsupport-v1.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/sstc-saml-metadata-ui-v1.0.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/xenc-schema.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/xml.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/schemas/xmldsig-core-schema.xsd',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/lib/Saml2/version.json',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/locale/en_US/LC_MESSAGES/phptoolkit.mo',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/locale/en_US/LC_MESSAGES/phptoolkit.po',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/locale/es_ES/LC_MESSAGES/phptoolkit.mo',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/locale/es_ES/LC_MESSAGES/phptoolkit.po',
            'modules/Users/authentication/SAML2Authenticate/lib/onelogin/php-saml/settings_example.php',
            'themes/SuiteP/css/suitep-base/suitepicon.html',
            'themes/SuiteP/css/suitep-base/tinemce.scss',
            'themes/default/css/skin.min.css'
        ];
    }
}
