<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2020 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

require_once 'modules/UpgradeWizard/UpgradeRemoval.php';

/**
 * Class UpgradeRemoval65x
 */
class UpgradeRemoval65x extends UpgradeRemoval
{
    /**
     * @var string minimal version for removal
     */
    public $version = '6.5.0';

    /**
     * getFilesToRemove
     * Return an array of files/directories to remove for 65x upgrades
     *
     * @param string $version
     *
     * @return array
     */
    public function getFilesToRemove($version)
    {
        return [
            'include/javascript/jstree/.gitignore',
            'include/javascript/jstree/bower.json',
            'include/javascript/jstree/component.json',
            'include/javascript/jstree/composer.json',
            'include/javascript/jstree/demo/README.md',
            'include/javascript/jstree/demo/basic/index.html',
            'include/javascript/jstree/demo/basic/root.json',
            'include/javascript/jstree/dist/jstree.min.js',
            'include/javascript/jstree/dist/themes/default-dark/32px.png',
            'include/javascript/jstree/dist/themes/default-dark/40px.png',
            'include/javascript/jstree/dist/themes/default-dark/style.css',
            'include/javascript/jstree/dist/themes/default-dark/style.min.css',
            'include/javascript/jstree/dist/themes/default-dark/throbber.gif',
            'include/javascript/jstree/dist/themes/default/32px.png',
            'include/javascript/jstree/dist/themes/default/40px.png',
            'include/javascript/jstree/dist/themes/default/style.css',
            'include/javascript/jstree/dist/themes/default/style.min.css',
            'include/javascript/jstree/dist/themes/default/throbber.gif',
            'include/javascript/jstree/gruntfile.js',
            'include/javascript/jstree/jstree.jquery.json',
            'include/javascript/jstree/package.json',
            'include/javascript/jstree/src/intro.js',
            'include/javascript/jstree/src/jstree.changed.js',
            'include/javascript/jstree/src/jstree.checkbox.js',
            'include/javascript/jstree/src/jstree.conditionalselect.js',
            'include/javascript/jstree/src/jstree.contextmenu.js',
            'include/javascript/jstree/src/jstree.dnd.js',
            'include/javascript/jstree/src/jstree.js',
            'include/javascript/jstree/src/jstree.massload.js',
            'include/javascript/jstree/src/jstree.search.js',
            'include/javascript/jstree/src/jstree.sort.js',
            'include/javascript/jstree/src/jstree.state.js',
            'include/javascript/jstree/src/jstree.types.js',
            'include/javascript/jstree/src/jstree.unique.js',
            'include/javascript/jstree/src/jstree.wholerow.js',
            'include/javascript/jstree/src/misc.js',
            'include/javascript/jstree/src/outro.js',
            'include/javascript/jstree/src/sample.js',
            'include/javascript/jstree/src/themes/base.less',
            'include/javascript/jstree/src/themes/default-dark/32px.png',
            'include/javascript/jstree/src/themes/default-dark/40px.png',
            'include/javascript/jstree/src/themes/default-dark/style.css',
            'include/javascript/jstree/src/themes/default-dark/style.less',
            'include/javascript/jstree/src/themes/default-dark/throbber.gif',
            'include/javascript/jstree/src/themes/default/32px.png',
            'include/javascript/jstree/src/themes/default/40px.png',
            'include/javascript/jstree/src/themes/default/style.css',
            'include/javascript/jstree/src/themes/default/style.less',
            'include/javascript/jstree/src/themes/default/throbber.gif',
            'include/javascript/jstree/src/themes/main.less',
            'include/javascript/jstree/src/themes/mixins.less',
            'include/javascript/jstree/src/themes/responsive.less',
            'include/javascript/jstree/src/vakata-jstree.js',
            'include/javascript/jstree/test/unit/index.html',
            'include/javascript/jstree/test/unit/libs/qunit.css',
            'include/javascript/jstree/test/unit/libs/qunit.js',
            'include/javascript/jstree/test/unit/test.js',
            'include/javascript/jstree/test/visual/desktop/index.html',
            'include/javascript/jstree/test/visual/mobile/index.html',
            'include/javascript/jstree/test/visual/screenshots/desktop/.png',
            'include/javascript/jstree/test/visual/screenshots/desktop/desktop.png',
            'include/javascript/jstree/test/visual/screenshots/desktop/home.png',
            'include/javascript/jstree/test/visual/screenshots/mobile/.png',
            'include/javascript/jstree/test/visual/screenshots/mobile/home.png',
            'include/javascript/jstree/test/visual/screenshots/mobile/mobile.png',
            'include/tcpdf/CHANGELOG.TXT',
            'include/tcpdf/LICENSE.TXT',
            'include/tcpdf/README.TXT',
            'lib/PDF/MPDF/configMapping.php',
            'modules/InboundEmail/DetailView.html',
            'modules/InboundEmail/DetailView.php',
            'modules/InboundEmail/EditView.html',
            'modules/InboundEmail/EditView.php',
            'modules/InboundEmail/ListView.html',
            'themes/SuiteP/css/suitep-base/tinemce.scss',
            'themes/default/css/skin.min.css'
        ];
    }
}
