<?php 
 $GLOBALS["dictionary"]["pt1_ProjectTracking"]=array (
  'table' => 'pt1_projecttracking',
  'audited' => true,
  'inline_edit' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_pt1_projecttracking',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'type' => 
    array (
      'required' => true,
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => 'type of project',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'project_type_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'customerpo' => 
    array (
      'required' => false,
      'name' => 'customerpo',
      'vname' => 'LBL_CUSTOMERPO',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => 'po number of the customer',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'orderdate' => 
    array (
      'required' => false,
      'name' => 'orderdate',
      'vname' => 'LBL_ORDERDATE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'billing' => 
    array (
      'required' => false,
      'name' => 'billing',
      'vname' => 'LBL_BILLING',
      'type' => 'enum',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'project_billing_list',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'iocnum' => 
    array (
      'required' => false,
      'name' => 'iocnum',
      'vname' => 'LBL_IOCNUM',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'contact_id_c' => 
    array (
      'required' => false,
      'name' => 'contact_id_c',
      'vname' => 'LBL_EMAILEDTO_CONTACT_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'emailedto' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'emailedto',
      'vname' => 'LBL_EMAILEDTO',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'contact_id_c',
      'ext2' => 'Contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'emailedon' => 
    array (
      'required' => false,
      'name' => 'emailedon',
      'vname' => 'LBL_EMAILEDON',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'iocconfirmed' => 
    array (
      'required' => false,
      'name' => 'iocconfirmed',
      'vname' => 'LBL_IOCCONFIRMED',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'shipped2sydon' => 
    array (
      'required' => false,
      'name' => 'shipped2sydon',
      'vname' => 'LBL_SHIPPED2SYDON',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'econ' => 
    array (
      'required' => false,
      'name' => 'econ',
      'vname' => 'LBL_ECON',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'requestamendpo' => 
    array (
      'required' => false,
      'name' => 'requestamendpo',
      'vname' => 'LBL_REQUESTAMENDPO',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'reason' => 
    array (
      'required' => false,
      'name' => 'reason',
      'vname' => 'LBL_REASON',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'contact_id1_c' => 
    array (
      'required' => false,
      'name' => 'contact_id1_c',
      'vname' => 'LBL_EMAILOCTO_CONTACT_ID',
      'type' => 'id',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'inline_edit' => true,
      'reportable' => false,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 36,
      'size' => '20',
    ),
    'emailocto' => 
    array (
      'required' => false,
      'source' => 'non-db',
      'name' => 'emailocto',
      'vname' => 'LBL_EMAILOCTO',
      'type' => 'relate',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id_name' => 'contact_id1_c',
      'ext2' => 'Contacts',
      'module' => 'Contacts',
      'rname' => 'name',
      'quicksearch' => 'enabled',
      'studio' => 'visible',
    ),
    'ocnum' => 
    array (
      'required' => false,
      'name' => 'ocnum',
      'vname' => 'LBL_OCNUM',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'ocsignendsales' => 
    array (
      'required' => false,
      'name' => 'ocsignendsales',
      'vname' => 'LBL_OCSIGNENDSALES',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'ocsignedcust' => 
    array (
      'required' => false,
      'name' => 'ocsignedcust',
      'vname' => 'LBL_OCSIGNEDCUST',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'preparedstock' => 
    array (
      'required' => false,
      'name' => 'preparedstock',
      'vname' => 'LBL_PREPAREDSTOCK',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'ourpo' => 
    array (
      'required' => false,
      'name' => 'ourpo',
      'vname' => 'LBL_OURPO',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'cico' => 
    array (
      'required' => false,
      'name' => 'cico',
      'vname' => 'LBL_CICO',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'shipdateci' => 
    array (
      'required' => false,
      'name' => 'shipdateci',
      'vname' => 'LBL_SHIPDATECI',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'licensereceived' => 
    array (
      'required' => false,
      'name' => 'licensereceived',
      'vname' => 'LBL_LICENSERECEIVED',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'psnum' => 
    array (
      'required' => false,
      'name' => 'psnum',
      'vname' => 'LBL_PSNUM',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'shipdate' => 
    array (
      'required' => false,
      'name' => 'shipdate',
      'vname' => 'LBL_SHIPDATE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'psecon' => 
    array (
      'required' => false,
      'name' => 'psecon',
      'vname' => 'LBL_PSECON',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'invnum' => 
    array (
      'required' => false,
      'name' => 'invnum',
      'vname' => 'LBL_INVNUM',
      'type' => 'varchar',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'signedsales' => 
    array (
      'required' => false,
      'name' => 'signedsales',
      'vname' => 'LBL_SIGNEDSALES',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'invoicedate' => 
    array (
      'required' => false,
      'name' => 'invoicedate',
      'vname' => 'LBL_INVOICEDATE',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'paidon' => 
    array (
      'required' => false,
      'name' => 'paidon',
      'vname' => 'LBL_PAIDON',
      'type' => 'date',
      'massupdate' => 0,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
    ),
    'requiresconfig' => 
    array (
      'required' => false,
      'name' => 'requiresconfig',
      'vname' => 'LBL_REQUIRESCONFIG',
      'type' => 'bool',
      'massupdate' => 0,
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'inline_edit' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
    ),
    'pt1_projecttracking_accounts' => 
    array (
      'name' => 'pt1_projecttracking_accounts',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_accounts',
      'source' => 'non-db',
      'module' => 'Accounts',
      'bean_name' => 'Account',
      'vname' => 'LBL_PT1_PROJECTTRACKING_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'id_name' => 'pt1_projecttracking_accountsaccounts_ida',
    ),
    'pt1_projecttracking_accounts_name' => 
    array (
      'name' => 'pt1_projecttracking_accounts_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PT1_PROJECTTRACKING_ACCOUNTS_FROM_ACCOUNTS_TITLE',
      'save' => true,
      'id_name' => 'pt1_projecttracking_accountsaccounts_ida',
      'link' => 'pt1_projecttracking_accounts',
      'table' => 'accounts',
      'module' => 'Accounts',
      'rname' => 'name',
    ),
    'pt1_projecttracking_accountsaccounts_ida' => 
    array (
      'name' => 'pt1_projecttracking_accountsaccounts_ida',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_accounts',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'right',
      'vname' => 'LBL_PT1_PROJECTTRACKING_ACCOUNTS_FROM_PT1_PROJECTTRACKING_TITLE',
    ),
    'pt1_projecttracking_opportunities' => 
    array (
      'name' => 'pt1_projecttracking_opportunities',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_opportunities',
      'source' => 'non-db',
      'module' => 'Opportunities',
      'bean_name' => 'Opportunity',
      'vname' => 'LBL_PT1_PROJECTTRACKING_OPPORTUNITIES_FROM_OPPORTUNITIES_TITLE',
      'id_name' => 'pt1_projecttracking_opportunitiesopportunities_idb',
    ),
    'pt1_projecttracking_opportunities_name' => 
    array (
      'name' => 'pt1_projecttracking_opportunities_name',
      'type' => 'relate',
      'source' => 'non-db',
      'vname' => 'LBL_PT1_PROJECTTRACKING_OPPORTUNITIES_FROM_OPPORTUNITIES_TITLE',
      'save' => true,
      'id_name' => 'pt1_projecttracking_opportunitiesopportunities_idb',
      'link' => 'pt1_projecttracking_opportunities',
      'table' => 'opportunities',
      'module' => 'Opportunities',
      'rname' => 'name',
    ),
    'pt1_projecttracking_opportunitiesopportunities_idb' => 
    array (
      'name' => 'pt1_projecttracking_opportunitiesopportunities_idb',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_opportunities',
      'source' => 'non-db',
      'reportable' => false,
      'side' => 'left',
      'vname' => 'LBL_PT1_PROJECTTRACKING_OPPORTUNITIES_FROM_OPPORTUNITIES_TITLE',
    ),
    'pt1_projecttracking_documents' => 
    array (
      'name' => 'pt1_projecttracking_documents',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_documents',
      'source' => 'non-db',
      'module' => 'Documents',
      'bean_name' => 'Document',
      'side' => 'right',
      'vname' => 'LBL_PT1_PROJECTTRACKING_DOCUMENTS_FROM_DOCUMENTS_TITLE',
    ),
    'pt1_projecttracking_tasks' => 
    array (
      'name' => 'pt1_projecttracking_tasks',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_tasks',
      'source' => 'non-db',
      'module' => 'Tasks',
      'bean_name' => 'Task',
      'side' => 'right',
      'vname' => 'LBL_PT1_PROJECTTRACKING_TASKS_FROM_TASKS_TITLE',
    ),
    'pt1_projecttracking_notes' => 
    array (
      'name' => 'pt1_projecttracking_notes',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_notes',
      'source' => 'non-db',
      'module' => 'Notes',
      'bean_name' => 'Note',
      'side' => 'right',
      'vname' => 'LBL_PT1_PROJECTTRACKING_NOTES_FROM_NOTES_TITLE',
    ),
    'ca_est_ship_date_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'CA est ship date',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ca_est_ship_date_c',
      'vname' => 'LBL_CA_EST_SHIP_DATE',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'pt1_ProjectTrackingca_est_ship_date_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'notes_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Notes',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'notes_c',
      'vname' => 'LBL_NOTES',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingnotes_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'invoice_to_customer_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'INV to customer',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'invoice_to_customer_c',
      'vname' => 'LBL_INVOICE_TO_CUSTOMER',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackinginvoice_to_customer_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'inv_customer_sent_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'INV customer sent',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'inv_customer_sent_c',
      'vname' => 'LBL_INV_CUSTOMER_SENT',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'pt1_ProjectTrackinginv_customer_sent_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'notes_order_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Notes',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'notes_order_c',
      'vname' => 'LBL_NOTES_ORDER',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingnotes_order_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'employees_list_tech_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Project Tech',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'employees_list_tech_c',
      'vname' => 'LBL_EMPLOYEES_LIST_TECH',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'employees_list_tech',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'pt1_ProjectTrackingemployees_list_tech_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'oc_mailed_on_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'OC mailed on',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'oc_mailed_on_c',
      'vname' => 'LBL_OC_MAILED_ON',
      'type' => 'date',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'enable_range_search' => false,
      'id' => 'pt1_ProjectTrackingoc_mailed_on_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'notes_oc_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'notes oc',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'notes_oc_c',
      'vname' => 'LBL_NOTES_OC',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingnotes_oc_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'part_shipments_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'part shipments',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'part_shipments_c',
      'vname' => 'LBL_PART_SHIPMENTS',
      'type' => 'bool',
      'massupdate' => '0',
      'default' => '0',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingpart_shipments_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'notes_ps_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Notes ',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'notes_ps_c',
      'vname' => 'LBL_NOTES_PS',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingnotes_ps_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'emailed_oc_to_txt_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'emailed OC to:',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'emailed_oc_to_txt_c',
      'vname' => 'LBL_EMAILED_OC_TO_TXT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingemailed_oc_to_txt_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'order_contact_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'contact',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'order_contact_c',
      'vname' => 'LBL_ORDER_CONTACT',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingorder_contact_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'ioc_emailed_to_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'IOC emailed to',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'ioc_emailed_to_c',
      'vname' => 'LBL_IOC_EMAILED_TO',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingioc_emailed_to_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'required_to_close_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'to close',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'required_to_close_c',
      'vname' => 'LBL_REQUIRED_TO_CLOSE',
      'type' => 'varchar',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => '255',
      'size' => '20',
      'id' => 'pt1_ProjectTrackingrequired_to_close_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'project_status_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Project Status',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'project_status_c',
      'vname' => 'LBL_PROJECT_STATUS',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => 'inprogress',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'projects_status_options',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'pt1_ProjectTrackingproject_status_c',
      'custom_module' => 'pt1_ProjectTracking',
    ),
    'pt1_projecttracking_aos_quotes_1' => 
    array (
      'name' => 'pt1_projecttracking_aos_quotes_1',
      'type' => 'link',
      'relationship' => 'pt1_projecttracking_aos_quotes_1',
      'source' => 'non-db',
      'module' => 'AOS_Quotes',
      'bean_name' => 'AOS_Quotes',
      'side' => 'right',
      'vname' => 'LBL_PT1_PROJECTTRACKING_AOS_QUOTES_1_FROM_AOS_QUOTES_TITLE',
    ),
  ),
  'relationships' => 
  array (
    'pt1_projecttracking_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'pt1_ProjectTracking',
      'rhs_table' => 'pt1_projecttracking',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'pt1_projecttracking_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'pt1_ProjectTracking',
      'rhs_table' => 'pt1_projecttracking',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'pt1_projecttracking_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'pt1_ProjectTracking',
      'rhs_table' => 'pt1_projecttracking',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_pt1_projecttracking' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'pt1_ProjectTracking',
      'rhs_table' => 'pt1_projecttracking',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'pt1_ProjectTracking',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'pt1_projecttrackingpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);