<?php
/*
 * Your installation or use of this SugarCRM file is subject to the applicable
 * terms available at
 * http://support.sugarcrm.com/06_Customer_Center/10_Master_Subscription_Agreements/.
 * If you do not agree to all of the applicable terms or do not have the
 * authority to bind the entity as an authorized representative, then do not
 * install or use this SugarCRM file.
 *
 * Copyright (C) SugarCRM Inc. All rights reserved.
 */

require_once "include/MVC/View/SugarView.php";


class ImportViewAuthenticatedSources extends SugarView
{
    /** {@inheritdoc} */
    public function process()
    {
        $sources = $this->getAuthenticatedImportableExternalEAPMs();

        header('Content-Type: application/json');
        echo json_encode($sources);
    }

    private function getAuthenticatedImportableExternalEAPMs()
    {
        return ExternalAPIFactory::getModuleDropDown('Import', false, false);
    }
}

// vim: ts=4 sw=4 et
