<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point'.__FILE__);
/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/

/*********************************************************************************

 * Description:  Defines the English language pack for the base application.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributor(s): ______________________________________..
 ********************************************************************************/
 
$vardefs = array(
    'fields' => array(
        'name' => array(
            'name'=>'name',
            'type'=>'name',
            'link' => true, // bug 39288 
            'dbType'=>'varchar',
            'vname'=>'LBL_NAME',
            'comment'=>'Name of the Sale',
            'unified_search'=>true,
            'full_text_search'=>array('boost' => 3),
            'audited'=>true,
            'merge_filter'=>'selected',
            'required' => true,
            'importable' => 'required',
            ),
        strtolower($object_name).'_type' => array(
            'name'=>strtolower($object_name).'_type',
            'vname'=>'LBL_TYPE',
            'type'=>'enum',
            'options'=>strtolower($object_name).'_type_dom',
            'len' => 100,
            'comment'=>'The Sale is of this type',
            ),
        'description'=> array(
                'name'=>'description',
                'vname'=>'LBL_DESCRIPTION',
                'type'=>'text',
                'comment'=>'Description of the sale',
                'rows' => 6,
                'cols' => 80,
             ),
        'lead_source' => array (
                'name' => 'lead_source',
                'vname' => 'LBL_LEAD_SOURCE',
                'type' => 'enum',
                'options' => 'lead_source_dom',
                'len' => '50',
                'comment' => 'Source of the sale',
              ),
        'amount' => array (
                'name' => 'amount',
                'vname' => 'LBL_AMOUNT',
                'type' => 'currency',
                'dbType' => 'double',
                'comment' => 'Unconverted amount of the sale',
                'duplicate_merge'=>'disabled',
                'required' => true,
              ),
        'amount_usdollar' => array (
                'name' => 'amount_usdollar',
                'vname' => 'LBL_AMOUNT_USDOLLAR',
                'type' => 'currency',
                'group'=>'amount',
                'dbType' => 'double',
                'disable_num_format' => true,
                'audited'=>true,
                'comment' => 'Formatted amount of the sale'
              ),
        'currency_id' => array (
                'name' => 'currency_id',
                'type' => 'id',
                'group'=>'currency_id',
                'vname' => 'LBL_CURRENCY',
                'function'=>array('name'=>'getCurrencyDropDown', 'returns'=>'html'),
                'reportable'=>false,
                'comment' => 'Currency used for display purposes'
              ),
        'currency_name'=> array(
                'name'=>'currency_name',
                'rname'=>'name',
                'id_name'=>'currency_id',
                'vname'=>'LBL_CURRENCY_NAME',
                'type'=>'relate',
                'isnull'=>'true',
                'table' => 'currencies',
                'module'=>'Currencies',
                'source' => 'non-db',
                'function'=>array('name'=>'getCurrencyNameDropDown', 'returns'=>'html'),
                'studio' => 'false',
             ),
        'currency_symbol'=> array(
                'name'=>'currency_symbol',
                'rname'=>'symbol',
                'id_name'=>'currency_id',
                'vname'=>'LBL_CURRENCY_SYMBOL',
                'type'=>'relate',
                'isnull'=>'true',
                'table' => 'currencies',
                'module'=>'Currencies',
                'source' => 'non-db',
                'function'=>array('name'=>'getCurrencySymbolDropDown', 'returns'=>'html'),
             ),
        'date_closed' => array (
                'name' => 'date_closed',
                'vname' => 'LBL_DATE_CLOSED',
                'type' => 'date',
                'audited'=>true,
                'required' => true,
                'comment' => 'Expected or actual date the sale will close',
                'enable_range_search' => true,
                'options' => 'date_range_search_dom',
              ),
        'next_step' => array (
                'name' => 'next_step',
                'vname' => 'LBL_NEXT_STEP',
                'type' => 'varchar',
                'len' => '100',
                'comment' => 'The next step in the sales process',
              ),
        'sales_stage' => array (
                'name' => 'sales_stage',
                'vname' => 'LBL_SALES_STAGE',
                'type' => 'enum',
                'options' => 'sales_stage_dom',
                'len' => 100,
                'audited'=>true,
                'comment' => 'Indication of progression towards closure',
                'required'=>true,
                'importable' => 'required',
              ),
        'probability' => array (
                'name' => 'probability',
                'vname' => 'LBL_PROBABILITY',
                'type' => 'int',
                'dbType' => 'double',
                'audited'=>true,
                'comment' => 'The probability of closure',
                'validation' => array('type' => 'range', 'min' => 0, 'max' => 100),
              )
        )
    );

// vim: ts=4 sw=4 et
