<?php
/**
 * LICENSE: The contents of this file are subject to the license agreement ("License") which is included
 * in the installation package (LICENSE.txt). By installing or using this file, you have unconditionally
 * agreed to the terms and conditions of the License, and you may not use this file except in compliance
 * with the License.
 *
 * @author Original Author HP - Simbanic
 */

require_once 'modules/ModuleBuilder/parsers/views/GridLayoutMetaDataParser.php';

class ParserAOS_PDF_Templates extends GridLayoutMetaDataParser {

	function init ()
	{
		if(array_key_exists('includes', $this->_viewdefs['templateMeta']))
		{
			$includes = $this->_viewdefs['templateMeta']['includes'];
		}
		else
		{
			$includes = array('file');
		}

		$simba_status = true;

		foreach ($includes as $include) {
			if(isset($include['file']))
			{
				if (strpos($include['file'], 'simba_pdf') !== false) {
					$simba_status = false;
					break;
				}
			}
		}

		if($simba_status == true)
		{
			$this->_viewdefs['templateMeta']['includes'][] = array(
	  			"file" => "custom/modules/AOS_PDF_Templates/simba_pdf/simbaAOS_PDF_Templates.js",
			);
		}
	}

	function remove()
	{
		if(array_key_exists('includes', $this->_viewdefs['templateMeta']))
		{
			$includes = $this->_viewdefs['templateMeta']['includes'];
			
			$simba_status = true;
			
			foreach ($includes as $key => $include) {
				if(isset($include['file']))
				{
					if (strpos($include['file'], 'simba_pdf') !== false) {
						unset($this->_viewdefs['templateMeta']['includes'][$key]);
					}
				}
			}
			$this->_viewdefs['templateMeta']['includes'] = array_values($this->_viewdefs['templateMeta']['includes']);
		}
	}
}