function populateVariables(type) {
    var module_name = $('#type').val();
    var substring = "subpanel_";
    reg_values = regularOptions[type];
    if (type.indexOf(substring) !== -1) {
        var myData = $.param({
            module: 'AOS_PDF_Templates',
            action: 'simbaAjaxPDFHandler',
            method: 'get_subpanel_list_variable',
            type: type,
            module_name: module_name,
            to_pdf: 1
        });
        $.ajax({
            type: "POST",
            url: "index.php",
            data: myData,
        }).success(function(response) {
            if(response.status == 200)
            {
                var my_reg_values = new Array();
                $.each(response.data, function(key, value) {
                    my_reg_values[key] = value;
                });
                document.getElementById('variable_name').innerHTML = '';
                document.getElementById('variable_text').value = '';
                var selector = document.getElementById('variable_name');
                for (var i in my_reg_values) {
                    selector.options[selector.options.length] = new Option(my_reg_values[i], i);
                }
            }
        }).error(function(error) {
            console.log('simbaAjaxPDFHandler >> populateModuleVariables');
            console.log(error);
            console.log('get_subpanel_list');
            alert("Something went wrong");
        });
    }
    document.getElementById('variable_name').innerHTML = '';
    document.getElementById('variable_text').value = '';

    var selector = document.getElementById('variable_name');
    for (var i in reg_values) {
        selector.options[selector.options.length] = new Option(reg_values[i], i);
    }
}

function populateModuleVariables(type) {
    mod_values = moduleOptions[type];
    var myData = $.param({
        module: 'AOS_PDF_Templates',
        action: 'simbaAjaxPDFHandler',
        method: 'get_subpanel_list',
        type: type,
        to_pdf: 1,
    });
    $.ajax({
        type: "POST",
        url: "index.php",
        data: myData,
    }).success(function(response) {
        if(response.status == 200)
        {
            if(jQuery.isEmptyObject(mod_values))
            {
                mod_values = {};
            }
            $.each(response.data, function(value, key) {
                var key = "subpanel_" + key;
                mod_values[key] = value;
            });
            document.getElementById('module_name').innerHTML = '';
            var selector = document.getElementById('module_name');
            for (var i in mod_values) {
                selector.options[selector.options.length] = new Option(mod_values[i], i);
            }
            populateVariables(type);
        }        
    }).error(function(error) {
        console.log('simbaAjaxPDFHandler >> populateModuleVariables');
        console.log(error);
        console.log('get_subpanel_list');
        alert("Something went wrong");
    });
    document.getElementById('module_name').innerHTML = '';

    var selector = document.getElementById('module_name');
    for (var i in mod_values) {
        selector.options[selector.options.length] = new Option(mod_values[i], i);
    }

    populateVariables(type);
}