<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

/**
 * LICENSE: The contents of this file are subject to the license agreement ("License") which is included
 * in the installation package (LICENSE.txt). By installing or using this file, you have unconditionally
 * agreed to the terms and conditions of the License, and you may not use this file except in compliance
 * with the License.
 *
 * @author     Original Author ALS - Simbanic
 */

global $current_user;

class simbaTemplateParser
{
    public function parse_template($string, $bean_arr)
    {
        foreach ($bean_arr as $bean_name => $bean_id) {

            $focus  = BeanFactory::getBean($bean_name, $bean_id);
            $string = simbaTemplateParser::parse_template_bean($string, $focus->table_name, $focus);

            foreach ($focus->field_defs as $focus_name => $focus_arr) {
                if ($focus_arr['type'] == 'relate') {
                    if (isset($focus_arr['module']) && $focus_arr['module'] != '' && $focus_arr['module'] != 'EmailAddress') {

                        $idName       = $focus_arr['id_name'];
                        $relate_focus = BeanFactory::getBean($focus_arr['module'], $focus->$idName);
                        
                        $string = simbaTemplateParser::parse_template_bean($string, $focus_arr['name'], $relate_focus);
                    }
                }
            }

        }
        return $string;
    }

    function parse_template_bean($string, $key, &$focus)
    {
        global $app_strings, $sugar_config;
        $repl_arr = array();
        foreach ($focus->field_defs as $field_def) {
            if (isset($field_def['name']) && $field_def['name'] != '') {
                $fieldName = $field_def['name'];
                if ($field_def['type'] == 'currency') {
                    $repl_arr[$key . "_" . $fieldName] = currency_format_number($focus->$fieldName, $params = array('currency_symbol' => false));
                } else if (($field_def['type'] == 'radioenum' || $field_def['type'] == 'enum' || $field_def['type'] == 'dynamicenum') && isset($field_def['options'])) {
                    $repl_arr[$key . "_" . $fieldName] = translate($field_def['options'], $focus->module_dir, $focus->$fieldName);
                } else if ($field_def['type'] == 'multienum' && isset($field_def['options'])) {
                    $mVals = unencodeMultienum($focus->$fieldName);
                    $translatedVals = array();
                    foreach($mVals as $mVal){
                        $translatedVals[] = translate($field_def['options'], $focus->module_dir, $mVal);
                    }
                    $repl_arr[$key . "_" . $fieldName] = implode(", ", $translatedVals);
                } //Fix for Windows Server as it needed to be converted to a string.
                else if ($field_def['type'] == 'int') {
                    $repl_arr[$key . "_" . $fieldName] = strval($focus->$fieldName);
                } else if ($field_def['type'] == 'bool') {
                    if($focus->$fieldName == "1"){
                        $repl_arr[$key . "_" . $fieldName] = "true";
                    }else{
                        $repl_arr[$key . "_" . $fieldName] = "false";
                    }
                } else if ($field_def['type'] == 'image') {
                    $secureLink = $sugar_config['site_url'] . '/' . "public/". $focus->id .  '_' . $fieldName;
                    $file_location = $sugar_config['upload_dir'] . '/'  . $focus->id .  '_' . $fieldName;
                    // create a copy with correct extension by mime type
                    if(!file_exists('public')) {
                        sugar_mkdir('public', 0777);
                    }
                    if(!copy($file_location, "public/{$focus->id}".  '_' . "$fieldName")) {
                        $secureLink = $sugar_config['site_url'] . '/'. $file_location;
                    }
                    
                    if(empty($focus->$fieldName)){
                        $repl_arr[$key . "_" . $fieldName] = ""; 
                    }
                    else{
                        $link = $secureLink;
                        $repl_arr[$key . "_" . $fieldName] = '<img src="' . $link . '" width="'.$field_def['width'].'" height="'.$field_def['height'].'"/>';
                    }
                } else {
                    $repl_arr[$key . "_" . $fieldName] = $focus->$fieldName;
                }
            }
        } // end foreach()
        krsort($repl_arr);
        reset($repl_arr);
        foreach ($repl_arr as $name => $value) {
            if (strpos($name, 'product_discount') > 0) {
                if ($value != '' && $value != '0.00') {
                    if ($repl_arr['aos_products_quotes_discount'] == 'Percentage') {
                        $sep = get_number_seperators();
                        $value = rtrim(rtrim(format_number($value), '0'), $sep[1]);//.$app_strings['LBL_PERCENTAGE_SYMBOL'];
                    }
                } else {
                    $value = '';
                }
            }
            if ($name === 'aos_products_product_image' && !empty($value)) {
                $value = '<img src="' . $value . '" class="img-responsive"/>';
            }
            if ($name === 'aos_products_quotes_product_qty') {
                $sep = get_number_seperators();
                $value = rtrim(rtrim(format_number($value), '0'), $sep[1]);
            }
            if ($name === 'aos_products_quotes_vat' || strpos($name, 'pct') > 0 || strpos($name, 'percent') > 0 || strpos($name, 'percentage') > 0) {
                $sep = get_number_seperators();
                $value = rtrim(rtrim(format_number($value), '0'), $sep[1]) . $app_strings['LBL_PERCENTAGE_SYMBOL'];
            }
            if ($focus->field_defs[$name]['dbType'] == 'datetime' &&
                (strpos($name, 'date') > 0 || strpos($name, 'expiration') > 0) ) {
                if ($value != '') {
                    $dt = explode(' ', $value);
                    $value = $dt[0];
                }
            }
            if ($value != '' && is_string($value)) {
                $string = str_replace("\$$name", $value, $string);
            } else if (strpos($name, 'address') > 0) {
                $string = str_replace("\$$name<br />", '', $string);
                $string = str_replace("\$$name <br />", '', $string);
                $string = str_replace("\$$name", '', $string);
            } else {
                $string = str_replace("\$$name", '&nbsp;', $string);
            }
        }
        return $string;
    }
}