<?php
if (!defined('sugarEntry')) {
    define('sugarEntry', true);
}

/**
* LICENSE: The contents of this file are subject to the license agreement ("License") which is included
* in the installation package (LICENSE.txt). By installing or using this file, you have unconditionally
* agreed to the terms and conditions of the License, and you may not use this file except in compliance
* with the License.
*
* @author     Original Author HP - Simbanic
*/

class simbaAjaxPDFHandler
{
    function get_subpanel_list()
    {
        require_once 'include/SubPanel/SubPanel.php';
        require_once 'include/SubPanel/SubPanelDefinitions.php';

        global $dictionary, $beanList;

        $type = isset($_REQUEST['type']) ? trim($_REQUEST['type']) : '';
        $http_status = 401;
        $message = 'Unauthorized';
        $data = array();

        if(!empty($type))
        {
            if(array_key_exists($type, $beanList))
            {
                $arr           = SubPanel::getModuleSubpanels($type);
                $flipped_array = array_flip($arr);
                $moduleBean    = $beanList[$type];
                $focusBean     = BeanFactory::newBean($type);
                
                $linked_fields = $focusBean->get_linked_fields();
                foreach ($flipped_array as $key => $value) {
                    $key = translate($key, $type);
                    if ($value == $linked_fields[$value]['name']) {
                        $new_value  = $linked_fields[$value]['relationship'];
                        $data[$key] = $new_value;
                    } else if ($dictionary[$moduleBean]["relationships"][$value]) {
                        $data[$key] = $value;
                    } else {
                        $tempModuleBeanToCheckRelationship = strtolower($moduleBean);
                        $spd                               = new SubPanelDefinitions($focusBean);
                        $get_subpanel_data                 = $spd->layout_defs['subpanel_setup'][$value]['get_subpanel_data'];
                        $get_subpanel_value                = $linked_fields[$get_subpanel_data]['relationship'];
                        $data[$key]                        = $get_subpanel_value;
                    }
                }
                $http_status = 200;
                $message = 'Listed';
            }
            else
            {
                $message = 'Module does not exist';
                $GLOBALS['log']->fatal('get_subpanel_list :: Module does not exist'. print_r($_REQUEST, true) . __FILE__ . __LINE__);
            }
        }
        else
        {
            $message = 'Required Fields';
            $GLOBALS['log']->fatal('get_subpanel_list :: Required Fields : type '. print_r($_REQUEST, true) . __FILE__ . __LINE__);
        }

        $json = array(
            'status' => $http_status,
            'message' => $message,
            'data' => $data
        );
        header("Content-type: application/json");
        http_response_code($http_status);
        echo json_encode($json);
    }

    function get_subpanel_list_variable()
    {
        require_once 'include/utils.php';
        require_once 'include/SubPanel/SubPanelDefinitions.php';

        global $dictionary, $current_language, $beanList, $layout_defs;

        $type              = isset($_REQUEST['type']) ? trim($_REQUEST['type']) : '';
        $module_name       = isset($_REQUEST['module_name']) ? trim($_REQUEST['module_name']) : '';
        $relationship_name = str_replace("subpanel_", "", $type);

        $http_status = 401;
        $message = 'Unauthorized';
        $data = array();

        if (!empty($type) && !empty($module_name))
        {
            if(array_key_exists($module_name, $beanList))
            {
                $variables_list     = array();
                $parent_module_name = $beanList[$module_name];

                if (!empty($type) && !empty($module_name)) {
                    if ($dictionary[$relationship_name]['relationships'][$relationship_name]['lhs_module'] == $module_name) {
                        $moduleNameToRetrieveField = $dictionary[$relationship_name]['relationships'][$relationship_name]['rhs_module'];
                    }
                    if ($dictionary[$relationship_name]['relationships'][$relationship_name]['rhs_module'] == $module_name) {
                        $moduleNameToRetrieveField = $dictionary[$relationship_name]['relationships'][$relationship_name]['lhs_module'];
                    }

                    if ($moduleNameToRetrieveField == "") {
                        $bean                              = BeanFactory::getBean($module_name);
                        $tempModuleBeanToCheckRelationship = strtolower($beanList[$module_name]);
                        $spd                               = new SubPanelDefinitions($bean);
                        $aSubPanelObject                   = $spd->load_subpanel($relationship_name);
                        $moduleNameToRetrieveField         = $aSubPanelObject->_instance_properties['module'];
                    }
                    if ($dictionary[$parent_module_name]['relationships'][$relationship_name]['lhs_module'] == $module_name) {
                        $moduleNameToRetrieveField = $dictionary[$parent_module_name]['relationships'][$relationship_name]['rhs_module'];
                    }
                    if ($dictionary[$parent_module_name]['relationships'][$relationship_name]['rhs_module'] == $module_name) {
                        $moduleNameToRetrieveField = $dictionary[$parent_module_name]['relationships'][$relationship_name]['lhs_module'];
                    }

                    $mod_strings             = return_module_language($current_language, $moduleNameToRetrieveField);
                    $moduleBean              = $beanList[$moduleNameToRetrieveField];
                    $beanObj                 = new $moduleBean;
                    $field_defs[$moduleBean] = $beanObj->getFieldDefinitions();

                    foreach ($field_defs[$moduleBean] as $field => $value_array) {

                        $key = "$" . $relationship_name . "_" . $field;
                        foreach ($mod_strings as $label => $labelValue) {
                            if ($label == $value_array['vname']) {
                                $getLabel = $labelValue;
                                $data[$key] = $getLabel;
                            } else {
                                continue;
                            }
                        }
                    }

                    $http_status = 200;
                    $message = 'Listed';
                }
            }
            else
            {
                $message = 'Module does not exist';
                $GLOBALS['log']->fatal('get_subpanel_list_variable :: Module does not exist'. print_r($_REQUEST, true) . __FILE__ . __LINE__);
            }
        }
        else
        {
            $message = 'Required Fields';
            $GLOBALS['log']->fatal('get_subpanel_list_variable :: Required Fields : type & module '. print_r($_REQUEST, true) . __FILE__ . __LINE__);
        }

        $json = array(
            'status' => $http_status,
            'message' => $message,
            'data' => $data
        );
        header("Content-type: application/json");
        http_response_code($http_status);
        echo json_encode($json);
    }
}


if (isset($_REQUEST['method']) && !empty($_REQUEST['method'])) 
{
    $method = trim($_REQUEST['method']);
    $oSimbaAjaxPDFHandler = new simbaAjaxPDFHandler();

    if(method_exists($oSimbaAjaxPDFHandler, $method))
    {
        $oSimbaAjaxPDFHandler->$method();
    }
    else 
    {
        $status = 401;
        http_response_code($status);
        $response = array(
            'status' => $status,
            'message' => 'Unauthorized Request',
            'data' => array()
        );
        echo json_encode($response);
        exit;
    }
}