<?php 
 $GLOBALS["dictionary"]["AOR_Report"]=array (
  'table' => 'aor_reports',
  'audited' => true,
  'duplicate_merge' => true,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'aor_reports_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'aor_reports_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'aor_reports_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_aor_reports',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'report_module' => 
    array (
      'required' => true,
      'name' => 'report_module',
      'vname' => 'LBL_REPORT_MODULE',
      'type' => 'enum',
      'massupdate' => 0,
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => true,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'aor_moduleList',
      'studio' => 'visible',
      'dependency' => false,
    ),
    'graphs_per_row' => 
    array (
      'required' => true,
      'name' => 'graphs_per_row',
      'vname' => 'LBL_GRAPHS_PER_ROW',
      'type' => 'int',
      'massupdate' => 0,
      'default' => 2,
      'no_default' => false,
    ),
    'field_lines' => 
    array (
      'required' => false,
      'name' => 'field_lines',
      'vname' => 'LBL_FIELD_LINES',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_field_lines',
        'returns' => 'html',
        'include' => 'modules/AOR_Fields/fieldLines.php',
      ),
    ),
    'condition_lines' => 
    array (
      'required' => false,
      'name' => 'condition_lines',
      'vname' => 'LBL_CONDITION_LINES',
      'type' => 'function',
      'source' => 'non-db',
      'massupdate' => 0,
      'importable' => 'false',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => 0,
      'audited' => false,
      'reportable' => false,
      'function' => 
      array (
        'name' => 'display_condition_lines',
        'returns' => 'html',
        'include' => 'modules/AOR_Conditions/conditionLines.php',
      ),
    ),
    'aor_fields' => 
    array (
      'name' => 'aor_fields',
      'type' => 'link',
      'relationship' => 'aor_reports_aor_fields',
      'module' => 'AOR_Fields',
      'bean_name' => 'AOR_Field',
      'source' => 'non-db',
      'id_name' => 'aor_report_id',
    ),
    'aor_conditions' => 
    array (
      'name' => 'aor_conditions',
      'type' => 'link',
      'relationship' => 'aor_reports_aor_conditions',
      'module' => 'AOR_Conditions',
      'bean_name' => 'AOR_Condition',
      'source' => 'non-db',
    ),
    'aor_charts' => 
    array (
      'name' => 'aor_charts',
      'type' => 'link',
      'relationship' => 'aor_charts_aor_reports',
      'source' => 'non-db',
      'id_name' => 'aor_report_id',
      'vname' => 'LBL_AOR_CHARTS',
    ),
    'aor_scheduled_reports' => 
    array (
      'name' => 'aor_scheduled_reports',
      'type' => 'link',
      'relationship' => 'aor_scheduled_reports_aor_reports',
      'module' => 'AOR_Scheduled_Reports',
      'bean_name' => 'AOR_Scheduled_Reports',
      'source' => 'non-db',
    ),
    'fromdate_c' => 
    array (
      'inline_edit' => '1',
      'options' => 'date_range_search_dom',
      'labelValue' => 'From date',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'fromdate_c',
      'vname' => 'LBL_FROMDATE',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'dbType' => 'datetime',
      'display_default' => 'now&12:00am',
      'id' => 'AOR_Reportsfromdate_c',
      'custom_module' => 'AOR_Reports',
    ),
    'todate_c' => 
    array (
      'inline_edit' => '1',
      'options' => 'date_range_search_dom',
      'labelValue' => 'To date',
      'enable_range_search' => '1',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'todate_c',
      'vname' => 'LBL_TODATE',
      'type' => 'datetimecombo',
      'massupdate' => '0',
      'default' => '',
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'size' => '20',
      'dbType' => 'datetime',
      'display_default' => 'now&11:45pm',
      'id' => 'AOR_Reportstodate_c',
      'custom_module' => 'AOR_Reports',
    ),
    'workcode_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'WORKCODE',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'workcode_c',
      'vname' => 'LBL_WORKCODE',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'Workcode',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOR_Reportsworkcode_c',
      'custom_module' => 'AOR_Reports',
    ),
    'technician_c' => 
    array (
      'inline_edit' => '1',
      'labelValue' => 'Technician',
      'required' => false,
      'source' => 'custom_fields',
      'name' => 'technician_c',
      'vname' => 'LBL_TECHNICIAN',
      'type' => 'enum',
      'massupdate' => '0',
      'default' => NULL,
      'no_default' => false,
      'comments' => '',
      'help' => '',
      'importable' => 'true',
      'duplicate_merge' => 'disabled',
      'duplicate_merge_dom_value' => '0',
      'audited' => false,
      'reportable' => true,
      'unified_search' => false,
      'merge_filter' => 'disabled',
      'len' => 100,
      'size' => '20',
      'options' => 'technician_list',
      'studio' => 'visible',
      'dependency' => false,
      'id' => 'AOR_Reportstechnician_c',
      'custom_module' => 'AOR_Reports',
    ),
  ),
  'relationships' => 
  array (
    'aor_reports_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Reports',
      'rhs_table' => 'aor_reports',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'aor_reports_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Reports',
      'rhs_table' => 'aor_reports',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'aor_reports_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Reports',
      'rhs_table' => 'aor_reports',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_aor_reports' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Reports',
      'rhs_table' => 'aor_reports',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'AOR_Reports',
    ),
    'aor_reports_aor_fields' => 
    array (
      'lhs_module' => 'AOR_Reports',
      'lhs_table' => 'aor_reports',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Fields',
      'rhs_table' => 'aor_fields',
      'rhs_key' => 'aor_report_id',
      'relationship_type' => 'one-to-many',
    ),
    'aor_reports_aor_conditions' => 
    array (
      'lhs_module' => 'AOR_Reports',
      'lhs_table' => 'aor_reports',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Conditions',
      'rhs_table' => 'aor_conditions',
      'rhs_key' => 'aor_report_id',
      'relationship_type' => 'one-to-many',
    ),
    'aor_scheduled_reports_aor_reports' => 
    array (
      'lhs_module' => 'AOR_Reports',
      'lhs_table' => 'aor_reports',
      'lhs_key' => 'id',
      'rhs_module' => 'AOR_Scheduled_Reports',
      'rhs_table' => 'aor_scheduled_reports',
      'rhs_key' => 'aor_report_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'optimistic_locking' => true,
  'unified_search' => true,
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'aor_reportspk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
  'custom_fields' => true,
);