<?php
/*****************************************
 * start outright_send_email
 *      @description  : Sent Email 
 *      @Author       : Outright 
 *      Date          : 
 *      @param   string    ---> $to   : Recipient Email 
 *      @param   string    ---> $email_subject : Subject of the email 
 *      @param   string    ---> $email_body    : Message of the email 
 *      @since 1.0.0
 *          
 * ***************************************/
 
function outright_send_email( $to, $email_subject, $email_body, $attachment = false){	
    require_once('include/SugarPHPMailer.php');
	$emailObj = new Email(); 
	$defaults = $emailObj->getSystemDefaultEmail();
    $mail = new SugarPHPMailer(); 
	$mail->setMailerForSystem(); 
	$mail->From     = $defaults['email']; 
	$mail->FromName = $defaults['name']; 
	$mail->isHTML(true);
	$mail->Subject  = $email_subject; 
	$mail->Body     = $email_body;
	$mail->prepForOutbound(); 
	$mail->AddAddress($to);
    if($attachment){
        $mail->addAttachment($attachment);
    }
	$return = array();
	if(!$mail->Send()) {
		ob_clean();
		$return['status'] = false;
		$return['errorMessage'] =  $mail->ErrorInfo;
		return $return;
	} // if
	$return['message'] ='Email Successfully send to ->'.$to;
	$return['status'] = true;
    if($attachment){
        $return['attachment']=true;
    }
	return $return;
}/**End outright_send_email**/

function outright_send_notification( $email_subject , $email_body , $to_email=false ){
		outright_error_log('Email Notification :: Going to notify '.$to_email,'outr_obr_tracker');

	if( $email_subject && $email_body ){
			require_once('include/SugarPHPMailer.php');
			$emailObj = new Email(); 
			$defaults = $emailObj->getSystemDefaultEmail();

			$mail = new SugarPHPMailer(); 
			$mail->setMailerForSystem(); 
			$mail->From = $defaults['email']; 
			$mail->FromName = $defaults['name']; 
			$mail->SMTPDebug = 0;
			$mail->isHTML(true);
			$mail->Subject = $email_subject; 
			$mail->Body = $email_body;
			$mail->prepForOutbound(); 
			if(!$to_email){
				$to_email = $defaults['email'];
			}
					$to_email =$mail->AddAddress($to_email);
				
		
			if(!$mail->Send()){
				outright_error_log('Email Notification Failed :: While sending email to '.$to_email,'outr_obr_tracker');
			}
		}
}


function outright_send_email_bulk( $to_arr, $email_subject ,$email_body , $cc = false, $bcc = false, $attachment = false ){
    require_once('include/SugarPHPMailer.php');
	$emailObj = new Email(); 
	$defaults = $emailObj->getSystemDefaultEmail();
    $mail = new SugarPHPMailer(); 
	$mail->setMailerForSystem(); 
	$mail->From     = $defaults['email']; 
	$mail->FromName = $defaults['name']; 
	$mail->isHTML(true);
	$mail->Subject  = $email_subject; 
	$mail->Body     = $email_body;
	$mail->prepForOutbound();
    if($cc){
        $mail->addCC($cc);
    }
    if($bcc){
        $mail->addBCC($bcc);
    }
    if($attachment){
        $mail->addAttachment($attachment);
    }
    if(is_array($to_arr)){
        $i=0;
        $return = array();
        foreach($to_arr as $key=>$single_record){
            $mail->AddAddress($single_record); 
            if(!$mail->Send()) {
                ob_clean();
                $return[$i]['status'] = false;
                $return[$i]['email'] =  $single_record;
                $return[$i]['errorMessage'] =  $mail->ErrorInfo;
                $i++;
				$mail->ClearAllRecipients();
                continue;
            }
            $return[$i]['status'] = true;
            if($attachment){
                $return[$i]['attachment'] = true;
            }
            $return[$i]['message'] ='Email Successfully send to ->'.$single_record;
            if($cc){
                $return[$i]['cc'] = $cc;
            }
            if($bcc){
                $return[$i]['bcc'] = $bcc;
            }
			$mail->ClearAllRecipients();
            $i++;
        }
        return $return;
    }else{
        $mail->AddAddress($to_arr);
        $return = array();
        if(!$mail->Send()) {
            ob_clean();
            $return['status'] = false;
            $return['errorMessage'] =  $mail->ErrorInfo;
            return $return;
        }
        $return['status'] = true;
        if($attachment){
            $return['attachment'] = true;
        }
        $return['message'] ='Email Successfully send to ->'.$to_arr;
        if($cc){
            $return['cc'] = $cc;
        }
        if($bcc){
            $return['bcc'] = $bcc;
        }
        return $return;
    }
}

function outright_send_email_new($to,$email_subject,$email_body){
    echo ' Going to send you an Email '.$to;
	require_once('include/SugarPHPMailer.php');
    $mail = new SugarPHPMailer(); 
    $mail->isSMTP();    
    $mail->Host = 'smtp.gmail.com'; 
    $mail->From     = 'outrightcrm19@gmail.com'; 
    $mail->FromName = 'outrightcrm';    
    $mail->Username = 'outrightcrm19@gmail.com'; // your email id
    $mail->Password = 'whsbchnnqizapajq'; // your password
    $mail->SMTPSecure = 'tls';                  
    $mail->Port = 587;     //587 is used for Outgoing Mail (SMTP) Server.
    $mail->SMTPAuth = true; 
    $mail->isHTML(true);
    $mail->Subject  = $email_subject; 
    $mail->Body     = $email_body; 
    $mail->AddAddress($to);
    $return = array();
    if(!$mail->Send()) {
        ob_clean();
        $return['status'] = false;
        $return['errorMessage'] =  $mail->ErrorInfo;
        return $return;
    }
    else{
    echo 'Email successfully sent!'.$to;
    }
    $return['status'] = true;
    return $return;
}

function outright_send_email_bulk_all( $to_arr, $email_subject ,$email_body , $cc = false, $bcc = false, $attachment = false ){
    require_once('include/SugarPHPMailer.php');
	$emailObj = new Email(); 
	$defaults = $emailObj->getSystemDefaultEmail();
    $mail = new SugarPHPMailer(); 
	$mail->setMailerForSystem(); 
	$mail->From     = $defaults['email']; 
	$mail->FromName = $defaults['name']; 
	$mail->isHTML(true);
	$mail->Subject  = $email_subject; 
	$mail->Body     = $email_body;
	$mail->prepForOutbound();
    if($cc){
        $mail->addCC($cc);
    }
    if($bcc){
        $mail->addBCC($bcc);
    }
    if($attachment){
        $mail->addAttachment($attachment);
    }
    if(is_array($to_arr)){
        $i=0;
        $return = array();
        foreach($to_arr as $key=>$single_record){
            $mail->AddAddress($single_record);           
            $email_data[$i]['email'] =  $single_record;         
            $i++;
        }
        if(!$mail->Send()) {
            ob_clean();
            $return['status'] = false;
            if($attachment){
                $return['attachment'] = true;
            }
            $return['errorMessage'] =  $mail->ErrorInfo;            
            if($cc){
                $return['cc'] = $cc;
            }
            if($bcc){
                $return['bcc'] = $bcc;
            }
            $return['email_addresses']=$email_data;
            return $return;
        }
        $return['status'] = true;
        if($attachment){
            $return['attachment'] = true;
        }           
        if($cc){
            $return['cc'] = $cc;
        }
        if($bcc){
            $return['bcc'] = $bcc;
        }
        $return['email_addresses']=$email_data;
        return $return;
        
    }else{
        $mail->AddAddress($to_arr);
        $return = array();
        if(!$mail->Send()) {
            ob_clean();
            $return['status'] = false;
            $return['errorMessage'] =  $mail->ErrorInfo;
            return $return;
        }
        $return['status'] = true;
        if($attachment){
            $return['attachment'] = true;
        }
        $return['message'] ='Email Successfully send to ->'.$to_arr;
        if($cc){
            $return['cc'] = $cc;
        }
        if($bcc){
            $return['bcc'] = $bcc;
        }
        return $return;
    }
}